#!/bin/bash
echo "********** User Data started at: $(date -R) **********"
echo "${subdomain}.squirro.com" > /etc/hostname
hostnamectl set-hostname ${subdomain}.squirro.com

# SSM agent installation commented out due to iam role creation issue
dnf install -y https://s3.amazonaws.com/ec2-downloads-windows/SSMAgent/latest/linux_amd64/amazon-ssm-agent.rpm
systemctl enable amazon-ssm-agent
systemctl start amazon-ssm-agent

# update the os
dnf update -y

#enable epel-release for both rocky 9 and rhel 9
dnf install -y epel-release

# install a few critical packages
dnf install -y awscli dnf-utils nano neovim unzip w3m

# if /bin/vim does not exist, place a symlink to neovim
if [ ! -f /bin/vim ]; then
  ln -s /usr/bin/nvim /bin/vim
fi

# Check if a reboot is required
needs-restarting -r

# Check the exit code of needs-restarting
if [ $? -eq 0 ]; then
  echo "No reboot required."
else
  echo "Reboot required. Rebooting now..."
  reboot
fi

echo "********** User Data completed at: $(date -R) **********"
