data "aws_availability_zones" "available" {}

# Data source for existing VPC
data "aws_vpc" "existing" {
  id = var.vpc_id
}

resource "aws_subnet" "public" {
  count = length(var.public_subnets_list)
  availability_zone = data.aws_availability_zones.available.names[count.index]
  cidr_block        = var.public_subnets_list[count.index]
  vpc_id            = data.aws_vpc.existing.id
  tags = tomap({
      "Name" = "${var.env}-public-subnet"
  })  
}
# Check for existing Internet Gateway
data "aws_internet_gateway" "existing" {
  filter {
    name   = "attachment.vpc-id"
    values = [data.aws_vpc.existing.id]
  }
}
resource "aws_route_table" "public" {
  vpc_id = data.aws_vpc.existing.id
  route {
    cidr_block = "0.0.0.0/0"
    gateway_id = data.aws_internet_gateway.existing.id
  }
  tags = tomap({
    "Name" = "${var.env}-Public-RT"
  })
}
resource "aws_route_table_association" "public" {
  count = length(var.public_subnets_list)
  subnet_id      = aws_subnet.public.*.id[count.index]
  route_table_id = aws_route_table.public.id
}