---
language:
- en
multilinguality:
- monolingual
task_categories:
- text-retrieval
source_datasets:
- https://huggingface.co/datasets/nguha/legalbench/viewer/consumer_contracts_qa
task_ids:
- document-retrieval
config_names:
- corpus
tags:
- text-retrieval
dataset_info:
  - config_name: default
    features:
      - name: query-id
        dtype: string
      - name: corpus-id
        dtype: string
      - name: score
        dtype: float64
    splits:
      - name: test
        num_examples: 396
  - config_name: corpus
    features:
      - name: _id
        dtype: string
      - name: title
        dtype: string
      - name: text
        dtype: string
    splits:
      - name: corpus
        num_examples: 154
  - config_name: queries
    features:
      - name: _id
        dtype: string
      - name: text
        dtype: string
    splits:
      - name: queries
        num_examples: 396
configs:
  - config_name: default
    data_files:
      - split: test
        path: qrels/test.jsonl
  - config_name: corpus
    data_files:
      - split: corpus
        path: corpus.jsonl
  - config_name: queries
    data_files:
      - split: queries
        path: queries.jsonl
---

**Legalbench_consumer_contracts_qa**
- Original link: https://huggingface.co/datasets/nguha/legalbench/viewer/consumer_contracts_qa
- The dataset includes questions and answers related to contracts.
- The query set comprises the questions about contracts.
- The corpus set consists of the contracts.


**Usage**
```
import datasets

# Download the dataset
queries = datasets.load_dataset("mteb/legalbench_consumer_contracts_qa", "queries")
documents = datasets.load_dataset("mteb/legalbench_consumer_contracts_qa", "corpus")
pair_labels = datasets.load_dataset("mteb/legalbench_consumer_contracts_qa", "default")
```