ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("./text_highlight_rules").TextHighlightRules,m=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},m.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:!0}]}};h.inherits(m,f),m.getTagRule=function(s){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},m.getStartRule=function(s){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:s}},m.getEndRule=function(s){return{token:"comment.doc",regex:"\\*\\/",next:s}},x.DocCommentHighlightRules=m}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("./doc_comment_highlight_rules").DocCommentHighlightRules,m=u("./text_highlight_rules").TextHighlightRules,s="[a-zA-Z\\$_\xA1-\uFFFF][a-zA-Z\\d\\$_\xA1-\uFFFF]*",a=function(g){var o=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier"),r="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void",t="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)";this.$rules={no_regex:[f.getStartRule("doc-start"),c("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+s+")(\\.)(prototype)(\\.)("+s+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+s+")(\\.)("+s+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+s+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+s+")(\\.)("+s+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+s+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+s+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:`from(?=\\s*('|"))`},{token:"keyword",regex:"(?:"+r+")\\b",next:"start"},{token:["support.constant"],regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:o,regex:s},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+s+")(\\.)("+s+")(\\s*)(=)(\\s*)(function)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:s},{regex:"",token:"empty",next:"no_regex"}],start:[f.getStartRule("doc-start"),c("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],function_arguments:[{token:"variable.parameter",regex:s},{token:"punctuation.operator",regex:"[, ]+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!g||!g.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(e,i,n){if(this.next=e=="{"?this.nextState:"",e=="{"&&n.length)n.unshift("start",i);else if(e=="}"&&n.length&&(n.shift(),this.next=n.shift(),this.next.indexOf("string")!=-1||this.next.indexOf("jsx")!=-1))return"paren.quasi.end";return e=="{"?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:t},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]}),(!g||g.jsx!=!1)&&d.call(this)),this.embedRules(f,"doc-",[f.getEndRule("no_regex")]),this.normalizeRules()};h.inherits(a,m);function d(){var g=s.replace("\\d","\\d\\-"),o={onMatch:function(t,e,i){var n=t.charAt(1)=="/"?2:1;return n==1?(e!=this.nextState?i.unshift(this.next,this.nextState,0):i.unshift(this.next),i[2]++):n==2&&e==this.nextState&&(i[1]--,(!i[1]||i[1]<0)&&(i.shift(),i.shift())),[{type:"meta.tag.punctuation."+(n==1?"":"end-")+"tag-open.xml",value:t.slice(0,n)},{type:"meta.tag.tag-name.xml",value:t.substr(n)}]},regex:"</?"+g,next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(o);var r={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[r,o,{include:"reference"},{defaultToken:"string"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(t,e,i){return e==i[0]&&i.shift(),t.length==2&&(i[0]==this.nextState&&i[1]--,(!i[1]||i[1]<0)&&i.splice(0,2)),this.next=i[0]||"start",[{type:this.token,value:t}]},nextState:"jsx"},r,c("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:g},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},o],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function c(g){return[{token:"comment",regex:/\/\*/,next:[f.getTagRule(),{token:"comment",regex:"\\*\\/",next:g||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[f.getTagRule(),{token:"comment",regex:"$|^",next:g||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}x.JavaScriptHighlightRules=a}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(u,x,k){"use strict";var h=u("../range").Range,f=function(){};(function(){this.checkOutdent=function(m,s){return/^\s+$/.test(m)?/^\s*\}/.test(s):!1},this.autoOutdent=function(m,s){var a=m.getLine(s),d=a.match(/^(\s*\})/);if(!d)return 0;var c=d[1].length,g=m.findMatchingBracket({row:s,column:c});if(!g||g.row==s)return 0;var o=this.$getIndent(m.getLine(g.row));m.replace(new h(s,0,s,c-1),o)},this.$getIndent=function(m){return m.match(/^\s*/)[0]}}).call(f.prototype),x.MatchingBraceOutdent=f}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(u,x,k){"use strict";var h=u("../../lib/oop"),f=u("../../range").Range,m=u("./fold_mode").FoldMode,s=x.FoldMode=function(a){a&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+a.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+a.end)))};h.inherits(s,m),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(a,d,c){var g=a.getLine(c);if(this.singleLineBlockCommentRe.test(g)&&!this.startRegionRe.test(g)&&!this.tripleStarBlockCommentRe.test(g))return"";var o=this._getFoldWidgetBase(a,d,c);return!o&&this.startRegionRe.test(g)?"start":o},this.getFoldWidgetRange=function(a,d,c,g){var o=a.getLine(c);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(a,o,c);var e=o.match(this.foldingStartMarker);if(e){var r=e.index;if(e[1])return this.openingBracketBlock(a,e[1],c,r);var t=a.getCommentFoldRange(c,r+e[0].length,1);return t&&!t.isMultiLine()&&(g?t=this.getSectionRange(a,c):d!="all"&&(t=null)),t}if(d!=="markbegin"){var e=o.match(this.foldingStopMarker);if(e){var r=e.index+e[0].length;return e[1]?this.closingBracketBlock(a,e[1],c,r):a.getCommentFoldRange(c,r,-1)}}},this.getSectionRange=function(a,d){var c=a.getLine(d),g=c.search(/\S/),o=d,r=c.length;d=d+1;for(var t=d,e=a.getLength();++d<e;){c=a.getLine(d);var i=c.search(/\S/);if(i!==-1){if(g>i)break;var n=this.getFoldWidgetRange(a,"all",d);if(n){if(n.start.row<=o)break;if(n.isMultiLine())d=n.end.row;else if(g==i)break}t=d}}return new f(o,r,t,a.getLine(t).length)},this.getCommentRegionBlock=function(a,d,c){for(var g=d.search(/\s*$/),o=a.getLength(),r=c,t=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,e=1;++c<o;){d=a.getLine(c);var i=t.exec(d);if(i&&(i[1]?e--:e++,!e))break}var n=c;if(n>r)return new f(r,g,n,d.length)}}.call(s.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("./text").Mode,m=u("./javascript_highlight_rules").JavaScriptHighlightRules,s=u("./matching_brace_outdent").MatchingBraceOutdent,a=u("../worker/worker_client").WorkerClient,d=u("./behaviour/cstyle").CstyleBehaviour,c=u("./folding/cstyle").FoldMode,g=function(){this.HighlightRules=m,this.$outdent=new s,this.$behaviour=new d,this.foldingRules=new c};h.inherits(g,f),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.getNextLineIndent=function(o,r,t){var e=this.$getIndent(r),i=this.getTokenizer().getLineTokens(r,o),n=i.tokens,l=i.state;if(n.length&&n[n.length-1].type=="comment")return e;if(o=="start"||o=="no_regex"){var p=r.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);p&&(e+=t)}else if(o=="doc-start"){if(l=="start"||l=="no_regex")return"";var p=r.match(/^\s*(\/?)\*/);p&&(p[1]&&(e+=" "),e+="* ")}return e},this.checkOutdent=function(o,r,t){return this.$outdent.checkOutdent(r,t)},this.autoOutdent=function(o,r,t){this.$outdent.autoOutdent(r,t)},this.createWorker=function(o){var r=new a(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return r.attachToDocument(o.getDocument()),r.on("annotate",function(t){o.setAnnotations(t.data)}),r.on("terminate",function(){o.clearAnnotations()}),r},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(g.prototype),x.Mode=g}),ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("../lib/lang"),m=u("./text_highlight_rules").TextHighlightRules,s=x.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",a=x.supportFunction="rgb|rgba|url|attr|counter|counters",d=x.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",c=x.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",g=x.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",o=x.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",r=x.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",t=x.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",e=function(){var i=this.createKeywordMapper({"support.function":a,"support.constant":d,"support.type":s,"support.constant.color":c,"support.constant.fonts":g},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:o},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+o+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:o},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:r},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:t},{include:"url"},{token:i,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};h.inherits(e,m),x.CssHighlightRules=e}),ace.define("ace/mode/css_completions",["require","exports","module"],function(u,x,k){"use strict";var h={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},f=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var m=document.createElement("c").style;for(var s in m)if(typeof m[s]=="string"){var a=s.replace(/[A-Z]/g,function(d){return"-"+d.toLowerCase()});h.hasOwnProperty(a)||(h[a]=1)}}this.completionsDefined=!0},this.getCompletions=function(m,s,a,d){if(this.completionsDefined||this.defineCompletions(),m==="ruleset"||s.$mode.$id=="ace/mode/scss"){var c=s.getLine(a.row).substr(0,a.column);return/:[^;]+$/.test(c)?(/([\w\-]+):[^:]*$/.test(c),this.getPropertyValueCompletions(m,s,a,d)):this.getPropertyCompletions(m,s,a,d)}return[]},this.getPropertyCompletions=function(m,s,a,d){var c=Object.keys(h);return c.map(function(g){return{caption:g,snippet:g+": $0;",meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(m,s,a,d){var c=s.getLine(a.row).substr(0,a.column),g=(/([\w\-]+):[^:]*$/.exec(c)||{})[1];if(!g)return[];var o=[];return g in h&&typeof h[g]=="object"&&(o=Object.keys(h[g])),o.map(function(r){return{caption:r,snippet:r,meta:"property value",score:1e6}})}}).call(f.prototype),x.CssCompletions=f}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(u,x,k){"use strict";var h=u("../../lib/oop"),f=u("../behaviour").Behaviour,m=u("./cstyle").CstyleBehaviour,s=u("../../token_iterator").TokenIterator,a=function(){this.inherit(m),this.add("colon","insertion",function(d,c,g,o,r){if(r===":"&&g.selection.isEmpty()){var t=g.getCursorPosition(),e=new s(o,t.row,t.column),i=e.getCurrentToken();if(i&&i.value.match(/\s+/)&&(i=e.stepBackward()),i&&i.type==="support.type"){var n=o.doc.getLine(t.row),l=n.substring(t.column,t.column+1);if(l===":")return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(n.substring(t.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(d,c,g,o,r){var t=o.doc.getTextRange(r);if(!r.isMultiLine()&&t===":"){var e=g.getCursorPosition(),i=new s(o,e.row,e.column),n=i.getCurrentToken();if(n&&n.value.match(/\s+/)&&(n=i.stepBackward()),n&&n.type==="support.type"){var l=o.doc.getLine(r.start.row),p=l.substring(r.end.column,r.end.column+1);if(p===";")return r.end.column++,r}}}),this.add("semicolon","insertion",function(d,c,g,o,r){if(r===";"&&g.selection.isEmpty()){var t=g.getCursorPosition(),e=o.doc.getLine(t.row),i=e.substring(t.column,t.column+1);if(i===";")return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(d,c,g,o,r){if(r==="!"&&g.selection.isEmpty()){var t=g.getCursorPosition(),e=o.doc.getLine(t.row);if(/^\s*(;|}|$)/.test(e.substring(t.column)))return{text:"!important",selection:[10,10]}}})};h.inherits(a,m),x.CssBehaviour=a}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("./text").Mode,m=u("./css_highlight_rules").CssHighlightRules,s=u("./matching_brace_outdent").MatchingBraceOutdent,a=u("../worker/worker_client").WorkerClient,d=u("./css_completions").CssCompletions,c=u("./behaviour/css").CssBehaviour,g=u("./folding/cstyle").FoldMode,o=function(){this.HighlightRules=m,this.$outdent=new s,this.$behaviour=new c,this.$completer=new d,this.foldingRules=new g};h.inherits(o,f),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(r,t,e){var i=this.$getIndent(t),n=this.getTokenizer().getLineTokens(t,r).tokens;if(n.length&&n[n.length-1].type=="comment")return i;var l=t.match(/^.*\{\s*$/);return l&&(i+=e),i},this.checkOutdent=function(r,t,e){return this.$outdent.checkOutdent(t,e)},this.autoOutdent=function(r,t,e){this.$outdent.autoOutdent(t,e)},this.getCompletions=function(r,t,e,i){return this.$completer.getCompletions(r,t,e,i)},this.createWorker=function(r){var t=new a(["ace"],"ace/mode/css_worker","Worker");return t.attachToDocument(r.getDocument()),t.on("annotate",function(e){r.setAnnotations(e.data)}),t.on("terminate",function(){r.clearAnnotations()}),t},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(o.prototype),x.Mode=o}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("./text_highlight_rules").TextHighlightRules,m=function(s){var a="[_:a-zA-Z\xC0-\uFFFF][-_:.a-zA-Z0-9\xC0-\uFFFF]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+a+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:a},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+a+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"-->",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+a+":)?"+a+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:a},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===m&&this.normalizeRules()};(function(){this.embedTagRules=function(s,a,d){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+d+".tag-name.xml"],regex:"(<)("+d+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:a+"start"}]}),this.$rules[d+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(c,g,o){return o.splice(0),this.token}}],this.embedRules(s,a,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+d+".tag-name.xml"],regex:"(</)("+d+"(?=\\s|>|$))",next:d+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(f.prototype),h.inherits(m,f),x.XmlHighlightRules=m}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("../lib/lang"),m=u("./css_highlight_rules").CssHighlightRules,s=u("./javascript_highlight_rules").JavaScriptHighlightRules,a=u("./xml_highlight_rules").XmlHighlightRules,d=f.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),c=function(){a.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(g,o){var r=d[o];return["meta.tag.punctuation."+(g=="<"?"":"end-")+"tag-open.xml","meta.tag"+(r?"."+r:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(m,"css-","style"),this.embedTagRules(new s({jsx:!1}).getRules(),"js-","script"),this.constructor===c&&this.normalizeRules()};h.inherits(c,a),x.HtmlHighlightRules=c}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(u,x,k){"use strict";var h=u("../../lib/oop"),f=u("../behaviour").Behaviour,m=u("../../token_iterator").TokenIterator,s=u("../../lib/lang");function a(c,g){return c&&c.type.lastIndexOf(g+".xml")>-1}var d=function(){this.add("string_dquotes","insertion",function(c,g,o,r,t){if(t=='"'||t=="'"){var e=t,i=r.doc.getTextRange(o.getSelectionRange());if(i!==""&&i!=="'"&&i!='"'&&o.getWrapBehavioursEnabled())return{text:e+i+e,selection:!1};var n=o.getCursorPosition(),l=r.doc.getLine(n.row),p=l.substring(n.column,n.column+1),v=new m(r,n.row,n.column),b=v.getCurrentToken();if(p==e&&(a(b,"attribute-value")||a(b,"string")))return{text:"",selection:[1,1]};if(b||(b=v.stepBackward()),!b)return;for(;a(b,"tag-whitespace")||a(b,"whitespace");)b=v.stepBackward();var y=!p||p.match(/\s/);if(a(b,"attribute-equals")&&(y||p==">")||a(b,"decl-attribute-equals")&&(y||p=="?"))return{text:e+e,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(c,g,o,r,t){var e=r.doc.getTextRange(t);if(!t.isMultiLine()&&(e=='"'||e=="'")){var i=r.doc.getLine(t.start.row),n=i.substring(t.start.column+1,t.start.column+2);if(n==e)return t.end.column++,t}}),this.add("autoclosing","insertion",function(c,g,o,r,t){if(t==">"){var e=o.getSelectionRange().start,i=new m(r,e.row,e.column),n=i.getCurrentToken()||i.stepBackward();if(!n||!(a(n,"tag-name")||a(n,"tag-whitespace")||a(n,"attribute-name")||a(n,"attribute-equals")||a(n,"attribute-value"))||a(n,"reference.attribute-value"))return;if(a(n,"attribute-value")){var l=i.getCurrentTokenColumn()+n.value.length;if(e.column<l)return;if(e.column==l){var p=i.stepForward();if(p&&a(p,"attribute-value"))return;i.stepBackward()}}if(/^\s*>/.test(r.getLine(e.row).slice(e.column)))return;for(;!a(n,"tag-name");)if(n=i.stepBackward(),n.value=="<"){n=i.stepForward();break}var v=i.getCurrentTokenRow(),b=i.getCurrentTokenColumn();if(a(i.stepBackward(),"end-tag-open"))return;var y=n.value;return v==e.row&&(y=y.substring(0,e.column-b)),this.voidElements.hasOwnProperty(y.toLowerCase())?void 0:{text:"></"+y+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(c,g,o,r,t){if(t==`
`){var e=o.getCursorPosition(),i=r.getLine(e.row),n=new m(r,e.row,e.column),l=n.getCurrentToken();if(l&&l.type.indexOf("tag-close")!==-1){if(l.value=="/>")return;for(;l&&l.type.indexOf("tag-name")===-1;)l=n.stepBackward();if(!l)return;var p=l.value,v=n.getCurrentTokenRow();if(l=n.stepBackward(),!l||l.type.indexOf("end-tag")!==-1)return;if(this.voidElements&&!this.voidElements[p]){var b=r.getTokenAt(e.row,e.column+1),i=r.getLine(v),y=this.$getIndent(i),w=y+r.getTabString();return b&&b.value==="</"?{text:`
`+w+`
`+y,selection:[1,w.length,1,w.length]}:{text:`
`+w}}}}})};h.inherits(d,f),x.XmlBehaviour=d}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(u,x,k){"use strict";var h=u("../../lib/oop"),f=u("./fold_mode").FoldMode,m=x.FoldMode=function(s,a){this.defaultMode=s,this.subModes=a};h.inherits(m,f),function(){this.$getMode=function(s){typeof s!="string"&&(s=s[0]);for(var a in this.subModes)if(s.indexOf(a)===0)return this.subModes[a];return null},this.$tryMode=function(s,a,d,c){var g=this.$getMode(s);return g?g.getFoldWidget(a,d,c):""},this.getFoldWidget=function(s,a,d){return this.$tryMode(s.getState(d-1),s,a,d)||this.$tryMode(s.getState(d),s,a,d)||this.defaultMode.getFoldWidget(s,a,d)},this.getFoldWidgetRange=function(s,a,d){var c=this.$getMode(s.getState(d-1));return(!c||!c.getFoldWidget(s,a,d))&&(c=this.$getMode(s.getState(d))),(!c||!c.getFoldWidget(s,a,d))&&(c=this.defaultMode),c.getFoldWidgetRange(s,a,d)}}.call(m.prototype)}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],function(u,x,k){"use strict";var h=u("../../lib/oop"),f=u("../../lib/lang"),m=u("../../range").Range,s=u("./fold_mode").FoldMode,a=u("../../token_iterator").TokenIterator,d=x.FoldMode=function(o,r){s.call(this),this.voidElements=o||{},this.optionalEndTags=h.mixin({},this.voidElements),r&&h.mixin(this.optionalEndTags,r)};h.inherits(d,s);var c=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function g(o,r){return o.type.lastIndexOf(r+".xml")>-1}(function(){this.getFoldWidget=function(o,r,t){var e=this._getFirstTagInLine(o,t);return e?e.closing||!e.tagName&&e.selfClosing?r=="markbeginend"?"end":"":!e.tagName||e.selfClosing||this.voidElements.hasOwnProperty(e.tagName.toLowerCase())||this._findEndTagInLine(o,t,e.tagName,e.end.column)?"":"start":this.getCommentFoldWidget(o,t)},this.getCommentFoldWidget=function(o,r){return/comment/.test(o.getState(r))&&/<!-/.test(o.getLine(r))?"start":""},this._getFirstTagInLine=function(o,r){for(var t=o.getTokens(r),e=new c,i=0;i<t.length;i++){var n=t[i];if(g(n,"tag-open")){if(e.end.column=e.start.column+n.value.length,e.closing=g(n,"end-tag-open"),n=t[++i],!n)return null;for(e.tagName=n.value,e.end.column+=n.value.length,i++;i<t.length;i++)if(n=t[i],e.end.column+=n.value.length,g(n,"tag-close")){e.selfClosing=n.value=="/>";break}return e}else if(g(n,"tag-close"))return e.selfClosing=n.value=="/>",e;e.start.column+=n.value.length}return null},this._findEndTagInLine=function(o,r,t,e){for(var i=o.getTokens(r),n=0,l=0;l<i.length;l++){var p=i[l];if(n+=p.value.length,!(n<e)&&g(p,"end-tag-open")&&(p=i[l+1],p&&p.value==t))return!0}return!1},this._readTagForward=function(o){var r=o.getCurrentToken();if(!r)return null;var t=new c;do if(g(r,"tag-open"))t.closing=g(r,"end-tag-open"),t.start.row=o.getCurrentTokenRow(),t.start.column=o.getCurrentTokenColumn();else if(g(r,"tag-name"))t.tagName=r.value;else if(g(r,"tag-close"))return t.selfClosing=r.value=="/>",t.end.row=o.getCurrentTokenRow(),t.end.column=o.getCurrentTokenColumn()+r.value.length,o.stepForward(),t;while(r=o.stepForward());return null},this._readTagBackward=function(o){var r=o.getCurrentToken();if(!r)return null;var t=new c;do{if(g(r,"tag-open"))return t.closing=g(r,"end-tag-open"),t.start.row=o.getCurrentTokenRow(),t.start.column=o.getCurrentTokenColumn(),o.stepBackward(),t;g(r,"tag-name")?t.tagName=r.value:g(r,"tag-close")&&(t.selfClosing=r.value=="/>",t.end.row=o.getCurrentTokenRow(),t.end.column=o.getCurrentTokenColumn()+r.value.length)}while(r=o.stepBackward());return null},this._pop=function(o,r){for(;o.length;){var t=o[o.length-1];if(!r||t.tagName==r.tagName)return o.pop();if(this.optionalEndTags.hasOwnProperty(t.tagName)){o.pop();continue}else return null}},this.getFoldWidgetRange=function(o,r,t){var e=this._getFirstTagInLine(o,t);if(!e)return this.getCommentFoldWidget(o,t)&&o.getCommentFoldRange(t,o.getLine(t).length);var i=e.closing||e.selfClosing,n=[],l;if(i)for(var p=new a(o,t,e.end.column),b={row:t,column:e.start.column};l=this._readTagBackward(p);){if(l.selfClosing){if(n.length)continue;return l.start.column+=l.tagName.length+2,l.end.column-=2,m.fromPoints(l.start,l.end)}if(l.closing)n.push(l);else if(this._pop(n,l),n.length==0)return l.start.column+=l.tagName.length+2,l.start.row==l.end.row&&l.start.column<l.end.column&&(l.start.column=l.end.column),m.fromPoints(l.start,b)}else{var p=new a(o,t,e.start.column),v={row:t,column:e.start.column+e.tagName.length+2};for(e.start.row==e.end.row&&(v.column=e.end.column);l=this._readTagForward(p);){if(l.selfClosing){if(n.length)continue;return l.start.column+=l.tagName.length+2,l.end.column-=2,m.fromPoints(l.start,l.end)}if(l.closing){if(this._pop(n,l),n.length==0)return m.fromPoints(v,l.start)}else n.push(l)}}}}).call(d.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(u,x,k){"use strict";var h=u("../../lib/oop"),f=u("./mixed").FoldMode,m=u("./xml").FoldMode,s=u("./cstyle").FoldMode,a=x.FoldMode=function(d,c){f.call(this,new m(d,c),{"js-":new s,"css-":new s})};h.inherits(a,f)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(u,x,k){"use strict";var h=u("../token_iterator").TokenIterator,f=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"],m=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"],s=f.concat(m),a={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},d=Object.keys(a);function c(t,e){return t.type.lastIndexOf(e+".xml")>-1}function g(t,e){for(var i=new h(t,e.row,e.column),n=i.getCurrentToken();n&&!c(n,"tag-name");)n=i.stepBackward();if(n)return n.value}function o(t,e){for(var i=new h(t,e.row,e.column),n=i.getCurrentToken();n&&!c(n,"attribute-name");)n=i.stepBackward();if(n)return n.value}var r=function(){};(function(){this.getCompletions=function(t,e,i,n){var l=e.getTokenAt(i.row,i.column);if(!l)return[];if(c(l,"tag-name")||c(l,"tag-open")||c(l,"end-tag-open"))return this.getTagCompletions(t,e,i,n);if(c(l,"tag-whitespace")||c(l,"attribute-name"))return this.getAttributeCompletions(t,e,i,n);if(c(l,"attribute-value"))return this.getAttributeValueCompletions(t,e,i,n);var p=e.getLine(i.row).substr(0,i.column);return/&[a-z]*$/i.test(p)?this.getHTMLEntityCompletions(t,e,i,n):[]},this.getTagCompletions=function(t,e,i,n){return d.map(function(l){return{value:l,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(t,e,i,n){var l=g(e,i);if(!l)return[];var p=s;return l in a&&(p=p.concat(Object.keys(a[l]))),p.map(function(v){return{caption:v,snippet:v+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(t,e,i,n){var l=g(e,i),p=o(e,i);if(!l)return[];var v=[];return l in a&&p in a[l]&&typeof a[l][p]=="object"&&(v=Object.keys(a[l][p])),v.map(function(b){return{caption:b,snippet:b,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(t,e,i,n){var l=["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"];return l.map(function(p){return{caption:p,snippet:p,meta:"html entity",score:1e6}})}}).call(r.prototype),x.HtmlCompletions=r}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(u,x,k){"use strict";var h=u("../lib/oop"),f=u("../lib/lang"),m=u("./text").Mode,s=u("./javascript").Mode,a=u("./css").Mode,d=u("./html_highlight_rules").HtmlHighlightRules,c=u("./behaviour/xml").XmlBehaviour,g=u("./folding/html").FoldMode,o=u("./html_completions").HtmlCompletions,r=u("../worker/worker_client").WorkerClient,t=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],e=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],i=function(n){this.fragmentContext=n&&n.fragmentContext,this.HighlightRules=d,this.$behaviour=new c,this.$completer=new o,this.createModeDelegates({"js-":s,"css-":a}),this.foldingRules=new g(this.voidElements,f.arrayToMap(e))};h.inherits(i,m),function(){this.blockComment={start:"<!--",end:"-->"},this.voidElements=f.arrayToMap(t),this.getNextLineIndent=function(n,l,p){return this.$getIndent(l)},this.checkOutdent=function(n,l,p){return!1},this.getCompletions=function(n,l,p,v){return this.$completer.getCompletions(n,l,p,v)},this.createWorker=function(n){if(this.constructor==i){var l=new r(["ace"],"ace/mode/html_worker","Worker");return l.attachToDocument(n.getDocument()),this.fragmentContext&&l.call("setOptions",[{context:this.fragmentContext}]),l.on("error",function(p){n.setAnnotations(p.data)}),l.on("terminate",function(){n.clearAnnotations()}),l}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(i.prototype),x.Mode=i}),ace.define("ace/mode/django",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/html_highlight_rules","ace/mode/text_highlight_rules"],function(u,x,k){var h=u("../lib/oop"),f=u("./html").Mode,m=u("./html_highlight_rules").HtmlHighlightRules,s=u("./text_highlight_rules").TextHighlightRules,a=function(){this.$rules={start:[{token:"string",regex:'".*?"'},{token:"string",regex:"'.*?'"},{token:"constant",regex:"[0-9]+"},{token:"variable",regex:"[-_a-zA-Z0-9:]+"}],tag:[{token:"entity.name.function",regex:"[a-zA-Z][_a-zA-Z0-9]*",next:"start"}]}};h.inherits(a,s);var d=function(){this.$rules=new m().getRules();for(var g in this.$rules)this.$rules[g].unshift({token:"comment.line",regex:"\\{#.*?#\\}"},{token:"comment.block",regex:"\\{\\%\\s*comment\\s*\\%\\}",merge:!0,next:"django-comment"},{token:"constant.language",regex:"\\{\\{",next:"django-start"},{token:"constant.language",regex:"\\{\\%",next:"django-tag"}),this.embedRules(a,"django-",[{token:"comment.block",regex:"\\{\\%\\s*endcomment\\s*\\%\\}",merge:!0,next:"start"},{token:"constant.language",regex:"\\%\\}",next:"start"},{token:"constant.language",regex:"\\}\\}",next:"start"}])};h.inherits(d,m);var c=function(){f.call(this),this.HighlightRules=d};h.inherits(c,f),function(){this.$id="ace/mode/django",this.snippetFileId="ace/snippets/django"}.call(c.prototype),x.Mode=c}),function(){ace.require(["ace/mode/django"],function(u){typeof module=="object"&&typeof exports=="object"&&module&&(module.exports=u)})}();
