ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("../lib/lang"),p=s("./text_highlight_rules").TextHighlightRules,c=h.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",n=h.supportFunction="rgb|rgba|url|attr|counter|counters",g=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",l=h.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",d=h.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",i=h.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",o=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",t=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",e=function(){var a=this.createKeywordMapper({"support.function":n,"support.constant":g,"support.type":c,"support.constant.color":l,"support.constant.fonts":d},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:i},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+i+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:i},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:o},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:t},{include:"url"},{token:a,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};f.inherits(e,p),h.CssHighlightRules=e}),ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./text_highlight_rules").TextHighlightRules,p=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},p.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:!0}]}};f.inherits(p,m),p.getTagRule=function(c){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},p.getStartRule=function(c){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:c}},p.getEndRule=function(c){return{token:"comment.doc",regex:"\\*\\/",next:c}},h.DocCommentHighlightRules=p}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./doc_comment_highlight_rules").DocCommentHighlightRules,p=s("./text_highlight_rules").TextHighlightRules,c="[a-zA-Z\\$_\xA1-\uFFFF][a-zA-Z\\d\\$_\xA1-\uFFFF]*",n=function(d){var i=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier"),o="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void",t="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)";this.$rules={no_regex:[m.getStartRule("doc-start"),l("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+c+")(\\.)(prototype)(\\.)("+c+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+c+")(\\.)("+c+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+c+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+c+")(\\.)("+c+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+c+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+c+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:`from(?=\\s*('|"))`},{token:"keyword",regex:"(?:"+o+")\\b",next:"start"},{token:["support.constant"],regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:i,regex:c},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+c+")(\\.)("+c+")(\\s*)(=)(\\s*)(function)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:c},{regex:"",token:"empty",next:"no_regex"}],start:[m.getStartRule("doc-start"),l("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],function_arguments:[{token:"variable.parameter",regex:c},{token:"punctuation.operator",regex:"[, ]+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!d||!d.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(e,a,r){if(this.next=e=="{"?this.nextState:"",e=="{"&&r.length)r.unshift("start",a);else if(e=="}"&&r.length&&(r.shift(),this.next=r.shift(),this.next.indexOf("string")!=-1||this.next.indexOf("jsx")!=-1))return"paren.quasi.end";return e=="{"?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:t},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]}),(!d||d.jsx!=!1)&&g.call(this)),this.embedRules(m,"doc-",[m.getEndRule("no_regex")]),this.normalizeRules()};f.inherits(n,p);function g(){var d=c.replace("\\d","\\d\\-"),i={onMatch:function(t,e,a){var r=t.charAt(1)=="/"?2:1;return r==1?(e!=this.nextState?a.unshift(this.next,this.nextState,0):a.unshift(this.next),a[2]++):r==2&&e==this.nextState&&(a[1]--,(!a[1]||a[1]<0)&&(a.shift(),a.shift())),[{type:"meta.tag.punctuation."+(r==1?"":"end-")+"tag-open.xml",value:t.slice(0,r)},{type:"meta.tag.tag-name.xml",value:t.substr(r)}]},regex:"</?"+d,next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(i);var o={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[o,i,{include:"reference"},{defaultToken:"string"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(t,e,a){return e==a[0]&&a.shift(),t.length==2&&(a[0]==this.nextState&&a[1]--,(!a[1]||a[1]<0)&&a.splice(0,2)),this.next=a[0]||"start",[{type:this.token,value:t}]},nextState:"jsx"},o,l("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:d},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},i],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function l(d){return[{token:"comment",regex:/\/\*/,next:[m.getTagRule(),{token:"comment",regex:"\\*\\/",next:d||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[m.getTagRule(),{token:"comment",regex:"$|^",next:d||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}h.JavaScriptHighlightRules=n}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./text_highlight_rules").TextHighlightRules,p=function(c){var n="[_:a-zA-Z\xC0-\uFFFF][-_:.a-zA-Z0-9\xC0-\uFFFF]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+n+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:n},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+n+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"-->",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+n+":)?"+n+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:n},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===p&&this.normalizeRules()};(function(){this.embedTagRules=function(c,n,g){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+g+".tag-name.xml"],regex:"(<)("+g+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:n+"start"}]}),this.$rules[g+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(l,d,i){return i.splice(0),this.token}}],this.embedRules(c,n,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+g+".tag-name.xml"],regex:"(</)("+g+"(?=\\s|>|$))",next:g+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(m.prototype),f.inherits(p,m),h.XmlHighlightRules=p}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("../lib/lang"),p=s("./css_highlight_rules").CssHighlightRules,c=s("./javascript_highlight_rules").JavaScriptHighlightRules,n=s("./xml_highlight_rules").XmlHighlightRules,g=m.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),l=function(){n.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(d,i){var o=g[i];return["meta.tag.punctuation."+(d=="<"?"":"end-")+"tag-open.xml","meta.tag"+(o?"."+o:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(p,"css-","style"),this.embedTagRules(new c({jsx:!1}).getRules(),"js-","script"),this.constructor===l&&this.normalizeRules()};f.inherits(l,n),h.HtmlHighlightRules=l}),ace.define("ace/mode/elixir_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./text_highlight_rules").TextHighlightRules,p=function(){this.$rules={start:[{token:["meta.module.elixir","keyword.control.module.elixir","meta.module.elixir","entity.name.type.module.elixir"],regex:"^(\\s*)(defmodule)(\\s+)((?:[A-Z]\\w*\\s*\\.\\s*)*[A-Z]\\w*)"},{token:"comment.documentation.heredoc",regex:'@(?:module|type)?doc (?:~[a-z])?"""',push:[{token:"comment.documentation.heredoc",regex:'\\s*"""',next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"comment.documentation.heredoc"}],comment:"@doc with heredocs is treated as documentation"},{token:"comment.documentation.heredoc",regex:'@(?:module|type)?doc ~[A-Z]"""',push:[{token:"comment.documentation.heredoc",regex:'\\s*"""',next:"pop"},{defaultToken:"comment.documentation.heredoc"}],comment:"@doc with heredocs is treated as documentation"},{token:"comment.documentation.heredoc",regex:"@(?:module|type)?doc (?:~[a-z])?'''",push:[{token:"comment.documentation.heredoc",regex:"\\s*'''",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"comment.documentation.heredoc"}],comment:"@doc with heredocs is treated as documentation"},{token:"comment.documentation.heredoc",regex:"@(?:module|type)?doc ~[A-Z]'''",push:[{token:"comment.documentation.heredoc",regex:"\\s*'''",next:"pop"},{defaultToken:"comment.documentation.heredoc"}],comment:"@doc with heredocs is treated as documentation"},{token:"comment.documentation.false",regex:"@(?:module|type)?doc false",comment:"@doc false is treated as documentation"},{token:"comment.documentation.string",regex:'@(?:module|type)?doc "',push:[{token:"comment.documentation.string",regex:'"',next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"comment.documentation.string"}],comment:"@doc with string is treated as documentation"},{token:"keyword.control.elixir",regex:"\\b(?:do|end|case|bc|lc|for|if|cond|unless|try|receive|fn|defmodule|defp?|defprotocol|defimpl|defrecord|defstruct|defmacrop?|defdelegate|defcallback|defmacrocallback|defexception|defoverridable|exit|after|rescue|catch|else|raise|throw|import|require|alias|use|quote|unquote|super)\\b(?![?!])",TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:"(?<!\\.)\\b(do|end|case|bc|lc|for|if|cond|unless|try|receive|fn|defmodule|defp?|defprotocol|defimpl|defrecord|defstruct|defmacrop?|defdelegate|defcallback|defmacrocallback|defexception|defoverridable|exit|after|rescue|catch|else|raise|throw|import|require|alias|use|quote|unquote|super)\\b(?![?!])"},{token:"keyword.operator.elixir",regex:"\\b(?:and|not|or|when|xor|in|inlist|inbits)\\b",TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:"(?<!\\.)\\b(and|not|or|when|xor|in|inlist|inbits)\\b",comment:" as above, just doesn't need a 'end' and does a logic operation"},{token:"constant.language.elixir",regex:"\\b(?:nil|true|false)\\b(?![?!])"},{token:"variable.language.elixir",regex:"\\b__(?:CALLER|ENV|MODULE|DIR)__\\b(?![?!])"},{token:["punctuation.definition.variable.elixir","variable.other.readwrite.module.elixir"],regex:"(@)([a-zA-Z_]\\w*)"},{token:["punctuation.definition.variable.elixir","variable.other.anonymous.elixir"],regex:"(&)(\\d*)"},{token:"variable.other.constant.elixir",regex:"\\b[A-Z]\\w*\\b"},{token:"constant.numeric.elixir",regex:"\\b(?:0x[\\da-fA-F](?:_?[\\da-fA-F])*|\\d(?:_?\\d)*(?:\\.(?![^[:space:][:digit:]])(?:_?\\d)*)?(?:[eE][-+]?\\d(?:_?\\d)*)?|0b[01]+|0o[0-7]+)\\b",TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:"\\b(0x\\h(?>_?\\h)*|\\d(?>_?\\d)*(\\.(?![^[:space:][:digit:]])(?>_?\\d)*)?([eE][-+]?\\d(?>_?\\d)*)?|0b[01]+|0o[0-7]+)\\b"},{token:"punctuation.definition.constant.elixir",regex:":'",push:[{token:"punctuation.definition.constant.elixir",regex:"'",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"constant.other.symbol.single-quoted.elixir"}]},{token:"punctuation.definition.constant.elixir",regex:':"',push:[{token:"punctuation.definition.constant.elixir",regex:'"',next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"constant.other.symbol.double-quoted.elixir"}]},{token:"punctuation.definition.string.begin.elixir",regex:"(?:''')",TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:"(?>''')",push:[{token:"punctuation.definition.string.end.elixir",regex:"^\\s*'''",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"support.function.variable.quoted.single.heredoc.elixir"}],comment:"Single-quoted heredocs"},{token:"punctuation.definition.string.begin.elixir",regex:"'",push:[{token:"punctuation.definition.string.end.elixir",regex:"'",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"support.function.variable.quoted.single.elixir"}],comment:"single quoted string (allows for interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:'(?:""")',TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:'(?>""")',push:[{token:"punctuation.definition.string.end.elixir",regex:'^\\s*"""',next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"string.quoted.double.heredoc.elixir"}],comment:"Double-quoted heredocs"},{token:"punctuation.definition.string.begin.elixir",regex:'"',push:[{token:"punctuation.definition.string.end.elixir",regex:'"',next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"string.quoted.double.elixir"}],comment:"double quoted string (allows for interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:'~[a-z](?:""")',TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:'~[a-z](?>""")',push:[{token:"punctuation.definition.string.end.elixir",regex:'^\\s*"""',next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"string.quoted.double.heredoc.elixir"}],comment:"Double-quoted heredocs sigils"},{token:"punctuation.definition.string.begin.elixir",regex:"~[a-z]\\{",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\}[a-z]*",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"string.interpolated.elixir"}],comment:"sigil (allow for interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[a-z]\\[",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\][a-z]*",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"string.interpolated.elixir"}],comment:"sigil (allow for interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[a-z]\\<",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\>[a-z]*",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"string.interpolated.elixir"}],comment:"sigil (allow for interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[a-z]\\(",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\)[a-z]*",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{defaultToken:"string.interpolated.elixir"}],comment:"sigil (allow for interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[a-z][^\\w]",push:[{token:"punctuation.definition.string.end.elixir",regex:"[^\\w][a-z]*",next:"pop"},{include:"#interpolated_elixir"},{include:"#escaped_char"},{include:"#escaped_char"},{defaultToken:"string.interpolated.elixir"}],comment:"sigil (allow for interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:'~[A-Z](?:""")',TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:'~[A-Z](?>""")',push:[{token:"punctuation.definition.string.end.elixir",regex:'^\\s*"""',next:"pop"},{defaultToken:"string.quoted.other.literal.upper.elixir"}],comment:"Double-quoted heredocs sigils"},{token:"punctuation.definition.string.begin.elixir",regex:"~[A-Z]\\{",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\}[a-z]*",next:"pop"},{defaultToken:"string.quoted.other.literal.upper.elixir"}],comment:"sigil (without interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[A-Z]\\[",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\][a-z]*",next:"pop"},{defaultToken:"string.quoted.other.literal.upper.elixir"}],comment:"sigil (without interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[A-Z]\\<",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\>[a-z]*",next:"pop"},{defaultToken:"string.quoted.other.literal.upper.elixir"}],comment:"sigil (without interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[A-Z]\\(",push:[{token:"punctuation.definition.string.end.elixir",regex:"\\)[a-z]*",next:"pop"},{defaultToken:"string.quoted.other.literal.upper.elixir"}],comment:"sigil (without interpolation)"},{token:"punctuation.definition.string.begin.elixir",regex:"~[A-Z][^\\w]",push:[{token:"punctuation.definition.string.end.elixir",regex:"[^\\w][a-z]*",next:"pop"},{defaultToken:"string.quoted.other.literal.upper.elixir"}],comment:"sigil (without interpolation)"},{token:["punctuation.definition.constant.elixir","constant.other.symbol.elixir"],regex:"(:)([a-zA-Z_][\\w@]*(?:[?!]|=(?![>=]))?|\\<\\>|===?|!==?|<<>>|<<<|>>>|~~~|::|<\\-|\\|>|=>|~|~=|=|/|\\\\\\\\|\\*\\*?|\\.\\.?\\.?|>=?|<=?|&&?&?|\\+\\+?|\\-\\-?|\\|\\|?\\|?|\\!|@|\\%?\\{\\}|%|\\[\\]|\\^(?:\\^\\^)?)",TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:"(?<!:)(:)(?>[a-zA-Z_][\\w@]*(?>[?!]|=(?![>=]))?|\\<\\>|===?|!==?|<<>>|<<<|>>>|~~~|::|<\\-|\\|>|=>|~|~=|=|/|\\\\\\\\|\\*\\*?|\\.\\.?\\.?|>=?|<=?|&&?&?|\\+\\+?|\\-\\-?|\\|\\|?\\|?|\\!|@|\\%?\\{\\}|%|\\[\\]|\\^(\\^\\^)?)",comment:"symbols"},{token:"punctuation.definition.constant.elixir",regex:"(?:[a-zA-Z_][\\w@]*(?:[?!])?):(?!:)",TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:"(?>[a-zA-Z_][\\w@]*(?>[?!])?)(:)(?!:)",comment:"symbols"},{token:["punctuation.definition.comment.elixir","comment.line.number-sign.elixir"],regex:"(#)(.*)"},{token:"constant.numeric.elixir",regex:"\\?(?:\\\\(?:x[\\da-fA-F]{1,2}(?![\\da-fA-F])\\b|[^xMC])|[^\\s\\\\])",TODO:"FIXME: regexp doesn't have js equivalent",originalRegex:"(?<!\\w)\\?(\\\\(x\\h{1,2}(?!\\h)\\b|[^xMC])|[^\\s\\\\])",comment:`
			matches questionmark-letters.

			examples (1st alternation = hex):
			?\\x1     ?\\x61

			examples (2rd alternation = escaped):
			?\\n      ?\\b

			examples (3rd alternation = normal):
			?a       ?A       ?0 
			?*       ?"       ?( 
			?.       ?#
			
			the negative lookbehind prevents against matching
			p(42.tainted?)
			`},{token:"keyword.operator.assignment.augmented.elixir",regex:"\\+=|\\-=|\\|\\|=|~=|&&="},{token:"keyword.operator.comparison.elixir",regex:"===?|!==?|<=?|>=?"},{token:"keyword.operator.bitwise.elixir",regex:"\\|{3}|&{3}|\\^{3}|<{3}|>{3}|~{3}"},{token:"keyword.operator.logical.elixir",regex:"!+|\\bnot\\b|&&|\\band\\b|\\|\\||\\bor\\b|\\bxor\\b",originalRegex:"(?<=[ \\t])!+|\\bnot\\b|&&|\\band\\b|\\|\\||\\bor\\b|\\bxor\\b"},{token:"keyword.operator.arithmetic.elixir",regex:"\\*|\\+|\\-|/"},{token:"keyword.operator.other.elixir",regex:"\\||\\+\\+|\\-\\-|\\*\\*|\\\\\\\\|\\<\\-|\\<\\>|\\<\\<|\\>\\>|\\:\\:|\\.\\.|\\|>|~|=>"},{token:"keyword.operator.assignment.elixir",regex:"="},{token:"punctuation.separator.other.elixir",regex:":"},{token:"punctuation.separator.statement.elixir",regex:"\\;"},{token:"punctuation.separator.object.elixir",regex:","},{token:"punctuation.separator.method.elixir",regex:"\\."},{token:"punctuation.section.scope.elixir",regex:"\\{|\\}"},{token:"punctuation.section.array.elixir",regex:"\\[|\\]"},{token:"punctuation.section.function.elixir",regex:"\\(|\\)"}],"#escaped_char":[{token:"constant.character.escape.elixir",regex:"\\\\(?:x[\\da-fA-F]{1,2}|.)"}],"#interpolated_elixir":[{token:["source.elixir.embedded.source","source.elixir.embedded.source.empty"],regex:"(#\\{)(\\})"},{todo:{token:"punctuation.section.embedded.elixir",regex:"#\\{",push:[{token:"punctuation.section.embedded.elixir",regex:"\\}",next:"pop"},{include:"#nest_curly_and_self"},{include:"$self"},{defaultToken:"source.elixir.embedded.source"}]}}],"#nest_curly_and_self":[{token:"punctuation.section.scope.elixir",regex:"\\{",push:[{token:"punctuation.section.scope.elixir",regex:"\\}",next:"pop"},{include:"#nest_curly_and_self"}]},{include:"$self"}],"#regex_sub":[{include:"#interpolated_elixir"},{include:"#escaped_char"},{token:["punctuation.definition.arbitrary-repitition.elixir","string.regexp.arbitrary-repitition.elixir","string.regexp.arbitrary-repitition.elixir","punctuation.definition.arbitrary-repitition.elixir"],regex:"(\\{)(\\d+)((?:,\\d+)?)(\\})"},{token:"punctuation.definition.character-class.elixir",regex:"\\[(?:\\^?\\])?",push:[{token:"punctuation.definition.character-class.elixir",regex:"\\]",next:"pop"},{include:"#escaped_char"},{defaultToken:"string.regexp.character-class.elixir"}]},{token:"punctuation.definition.group.elixir",regex:"\\(",push:[{token:"punctuation.definition.group.elixir",regex:"\\)",next:"pop"},{include:"#regex_sub"},{defaultToken:"string.regexp.group.elixir"}]},{token:["punctuation.definition.comment.elixir","comment.line.number-sign.elixir"],regex:"(?:^|\\s)(#)(\\s[[a-zA-Z0-9,. \\t?!-][^\\x00-\\x7F]]*$)",originalRegex:"(?<=^|\\s)(#)\\s[[a-zA-Z0-9,. \\t?!-][^\\x{00}-\\x{7F}]]*$",comment:"We are restrictive in what we allow to go after the comment character to avoid false positives, since the availability of comments depend on regexp flags."}]},this.normalizeRules()};p.metaData={comment:"Textmate bundle for Elixir Programming Language.",fileTypes:["ex","exs"],firstLineMatch:"^#!/.*\\belixir",foldingStartMarker:"(after|else|catch|rescue|\\-\\>|\\{|\\[|do)\\s*$",foldingStopMarker:"^\\s*((\\}|\\]|after|else|catch|rescue)\\s*$|end\\b)",keyEquivalent:"^~E",name:"Elixir",scopeName:"source.elixir"},f.inherits(p,m),h.ElixirHighlightRules=p}),ace.define("ace/mode/html_elixir_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/elixir_highlight_rules"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./html_highlight_rules").HtmlHighlightRules,p=s("./elixir_highlight_rules").ElixirHighlightRules,c=function(){m.call(this);var n=[{regex:"<%%|%%>",token:"constant.language.escape"},{token:"comment.start.eex",regex:"<%#",push:[{token:"comment.end.eex",regex:"%>",next:"pop",defaultToken:"comment"}]},{token:"support.elixir_tag",regex:"<%+(?!>)[-=]?",push:"elixir-start"}],g=[{token:"support.elixir_tag",regex:"%>",next:"pop"},{token:"comment",regex:"#(?:[^%]|%[^>])*"}];for(var l in this.$rules)this.$rules[l].unshift.apply(this.$rules[l],n);this.embedRules(p,"elixir-",g,["start"]),this.normalizeRules()};f.inherits(c,m),h.HtmlElixirHighlightRules=c}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(s,h,b){"use strict";var f=s("../range").Range,m=function(){};(function(){this.checkOutdent=function(p,c){return/^\s+$/.test(p)?/^\s*\}/.test(c):!1},this.autoOutdent=function(p,c){var n=p.getLine(c),g=n.match(/^(\s*\})/);if(!g)return 0;var l=g[1].length,d=p.findMatchingBracket({row:c,column:l});if(!d||d.row==c)return 0;var i=this.$getIndent(p.getLine(d.row));p.replace(new f(c,0,c,l-1),i)},this.$getIndent=function(p){return p.match(/^\s*/)[0]}}).call(m.prototype),h.MatchingBraceOutdent=m}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(s,h,b){"use strict";var f=s("../../lib/oop"),m=s("../../range").Range,p=s("./fold_mode").FoldMode,c=h.FoldMode=function(n){n&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+n.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+n.end)))};f.inherits(c,p),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(n,g,l){var d=n.getLine(l);if(this.singleLineBlockCommentRe.test(d)&&!this.startRegionRe.test(d)&&!this.tripleStarBlockCommentRe.test(d))return"";var i=this._getFoldWidgetBase(n,g,l);return!i&&this.startRegionRe.test(d)?"start":i},this.getFoldWidgetRange=function(n,g,l,d){var i=n.getLine(l);if(this.startRegionRe.test(i))return this.getCommentRegionBlock(n,i,l);var e=i.match(this.foldingStartMarker);if(e){var o=e.index;if(e[1])return this.openingBracketBlock(n,e[1],l,o);var t=n.getCommentFoldRange(l,o+e[0].length,1);return t&&!t.isMultiLine()&&(d?t=this.getSectionRange(n,l):g!="all"&&(t=null)),t}if(g!=="markbegin"){var e=i.match(this.foldingStopMarker);if(e){var o=e.index+e[0].length;return e[1]?this.closingBracketBlock(n,e[1],l,o):n.getCommentFoldRange(l,o,-1)}}},this.getSectionRange=function(n,g){var l=n.getLine(g),d=l.search(/\S/),i=g,o=l.length;g=g+1;for(var t=g,e=n.getLength();++g<e;){l=n.getLine(g);var a=l.search(/\S/);if(a!==-1){if(d>a)break;var r=this.getFoldWidgetRange(n,"all",g);if(r){if(r.start.row<=i)break;if(r.isMultiLine())g=r.end.row;else if(d==a)break}t=g}}return new m(i,o,t,n.getLine(t).length)},this.getCommentRegionBlock=function(n,g,l){for(var d=g.search(/\s*$/),i=n.getLength(),o=l,t=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,e=1;++l<i;){g=n.getLine(l);var a=t.exec(g);if(a&&(a[1]?e--:e++,!e))break}var r=l;if(r>o)return new m(o,d,r,g.length)}}.call(c.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./text").Mode,p=s("./javascript_highlight_rules").JavaScriptHighlightRules,c=s("./matching_brace_outdent").MatchingBraceOutdent,n=s("../worker/worker_client").WorkerClient,g=s("./behaviour/cstyle").CstyleBehaviour,l=s("./folding/cstyle").FoldMode,d=function(){this.HighlightRules=p,this.$outdent=new c,this.$behaviour=new g,this.foldingRules=new l};f.inherits(d,m),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.getNextLineIndent=function(i,o,t){var e=this.$getIndent(o),a=this.getTokenizer().getLineTokens(o,i),r=a.tokens,u=a.state;if(r.length&&r[r.length-1].type=="comment")return e;if(i=="start"||i=="no_regex"){var x=o.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);x&&(e+=t)}else if(i=="doc-start"){if(u=="start"||u=="no_regex")return"";var x=o.match(/^\s*(\/?)\*/);x&&(x[1]&&(e+=" "),e+="* ")}return e},this.checkOutdent=function(i,o,t){return this.$outdent.checkOutdent(o,t)},this.autoOutdent=function(i,o,t){this.$outdent.autoOutdent(o,t)},this.createWorker=function(i){var o=new n(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return o.attachToDocument(i.getDocument()),o.on("annotate",function(t){i.setAnnotations(t.data)}),o.on("terminate",function(){i.clearAnnotations()}),o},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(d.prototype),h.Mode=d}),ace.define("ace/mode/css_completions",["require","exports","module"],function(s,h,b){"use strict";var f={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},m=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var p=document.createElement("c").style;for(var c in p)if(typeof p[c]=="string"){var n=c.replace(/[A-Z]/g,function(g){return"-"+g.toLowerCase()});f.hasOwnProperty(n)||(f[n]=1)}}this.completionsDefined=!0},this.getCompletions=function(p,c,n,g){if(this.completionsDefined||this.defineCompletions(),p==="ruleset"||c.$mode.$id=="ace/mode/scss"){var l=c.getLine(n.row).substr(0,n.column);return/:[^;]+$/.test(l)?(/([\w\-]+):[^:]*$/.test(l),this.getPropertyValueCompletions(p,c,n,g)):this.getPropertyCompletions(p,c,n,g)}return[]},this.getPropertyCompletions=function(p,c,n,g){var l=Object.keys(f);return l.map(function(d){return{caption:d,snippet:d+": $0;",meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(p,c,n,g){var l=c.getLine(n.row).substr(0,n.column),d=(/([\w\-]+):[^:]*$/.exec(l)||{})[1];if(!d)return[];var i=[];return d in f&&typeof f[d]=="object"&&(i=Object.keys(f[d])),i.map(function(o){return{caption:o,snippet:o,meta:"property value",score:1e6}})}}).call(m.prototype),h.CssCompletions=m}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(s,h,b){"use strict";var f=s("../../lib/oop"),m=s("../behaviour").Behaviour,p=s("./cstyle").CstyleBehaviour,c=s("../../token_iterator").TokenIterator,n=function(){this.inherit(p),this.add("colon","insertion",function(g,l,d,i,o){if(o===":"&&d.selection.isEmpty()){var t=d.getCursorPosition(),e=new c(i,t.row,t.column),a=e.getCurrentToken();if(a&&a.value.match(/\s+/)&&(a=e.stepBackward()),a&&a.type==="support.type"){var r=i.doc.getLine(t.row),u=r.substring(t.column,t.column+1);if(u===":")return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(r.substring(t.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(g,l,d,i,o){var t=i.doc.getTextRange(o);if(!o.isMultiLine()&&t===":"){var e=d.getCursorPosition(),a=new c(i,e.row,e.column),r=a.getCurrentToken();if(r&&r.value.match(/\s+/)&&(r=a.stepBackward()),r&&r.type==="support.type"){var u=i.doc.getLine(o.start.row),x=u.substring(o.end.column,o.end.column+1);if(x===";")return o.end.column++,o}}}),this.add("semicolon","insertion",function(g,l,d,i,o){if(o===";"&&d.selection.isEmpty()){var t=d.getCursorPosition(),e=i.doc.getLine(t.row),a=e.substring(t.column,t.column+1);if(a===";")return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(g,l,d,i,o){if(o==="!"&&d.selection.isEmpty()){var t=d.getCursorPosition(),e=i.doc.getLine(t.row);if(/^\s*(;|}|$)/.test(e.substring(t.column)))return{text:"!important",selection:[10,10]}}})};f.inherits(n,p),h.CssBehaviour=n}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./text").Mode,p=s("./css_highlight_rules").CssHighlightRules,c=s("./matching_brace_outdent").MatchingBraceOutdent,n=s("../worker/worker_client").WorkerClient,g=s("./css_completions").CssCompletions,l=s("./behaviour/css").CssBehaviour,d=s("./folding/cstyle").FoldMode,i=function(){this.HighlightRules=p,this.$outdent=new c,this.$behaviour=new l,this.$completer=new g,this.foldingRules=new d};f.inherits(i,m),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(o,t,e){var a=this.$getIndent(t),r=this.getTokenizer().getLineTokens(t,o).tokens;if(r.length&&r[r.length-1].type=="comment")return a;var u=t.match(/^.*\{\s*$/);return u&&(a+=e),a},this.checkOutdent=function(o,t,e){return this.$outdent.checkOutdent(t,e)},this.autoOutdent=function(o,t,e){this.$outdent.autoOutdent(t,e)},this.getCompletions=function(o,t,e,a){return this.$completer.getCompletions(o,t,e,a)},this.createWorker=function(o){var t=new n(["ace"],"ace/mode/css_worker","Worker");return t.attachToDocument(o.getDocument()),t.on("annotate",function(e){o.setAnnotations(e.data)}),t.on("terminate",function(){o.clearAnnotations()}),t},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(s,h,b){"use strict";var f=s("../../lib/oop"),m=s("../behaviour").Behaviour,p=s("../../token_iterator").TokenIterator,c=s("../../lib/lang");function n(l,d){return l&&l.type.lastIndexOf(d+".xml")>-1}var g=function(){this.add("string_dquotes","insertion",function(l,d,i,o,t){if(t=='"'||t=="'"){var e=t,a=o.doc.getTextRange(i.getSelectionRange());if(a!==""&&a!=="'"&&a!='"'&&i.getWrapBehavioursEnabled())return{text:e+a+e,selection:!1};var r=i.getCursorPosition(),u=o.doc.getLine(r.row),x=u.substring(r.column,r.column+1),v=new p(o,r.row,r.column),k=v.getCurrentToken();if(x==e&&(n(k,"attribute-value")||n(k,"string")))return{text:"",selection:[1,1]};if(k||(k=v.stepBackward()),!k)return;for(;n(k,"tag-whitespace")||n(k,"whitespace");)k=v.stepBackward();var y=!x||x.match(/\s/);if(n(k,"attribute-equals")&&(y||x==">")||n(k,"decl-attribute-equals")&&(y||x=="?"))return{text:e+e,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(l,d,i,o,t){var e=o.doc.getTextRange(t);if(!t.isMultiLine()&&(e=='"'||e=="'")){var a=o.doc.getLine(t.start.row),r=a.substring(t.start.column+1,t.start.column+2);if(r==e)return t.end.column++,t}}),this.add("autoclosing","insertion",function(l,d,i,o,t){if(t==">"){var e=i.getSelectionRange().start,a=new p(o,e.row,e.column),r=a.getCurrentToken()||a.stepBackward();if(!r||!(n(r,"tag-name")||n(r,"tag-whitespace")||n(r,"attribute-name")||n(r,"attribute-equals")||n(r,"attribute-value"))||n(r,"reference.attribute-value"))return;if(n(r,"attribute-value")){var u=a.getCurrentTokenColumn()+r.value.length;if(e.column<u)return;if(e.column==u){var x=a.stepForward();if(x&&n(x,"attribute-value"))return;a.stepBackward()}}if(/^\s*>/.test(o.getLine(e.row).slice(e.column)))return;for(;!n(r,"tag-name");)if(r=a.stepBackward(),r.value=="<"){r=a.stepForward();break}var v=a.getCurrentTokenRow(),k=a.getCurrentTokenColumn();if(n(a.stepBackward(),"end-tag-open"))return;var y=r.value;return v==e.row&&(y=y.substring(0,e.column-k)),this.voidElements.hasOwnProperty(y.toLowerCase())?void 0:{text:"></"+y+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(l,d,i,o,t){if(t==`
`){var e=i.getCursorPosition(),a=o.getLine(e.row),r=new p(o,e.row,e.column),u=r.getCurrentToken();if(u&&u.type.indexOf("tag-close")!==-1){if(u.value=="/>")return;for(;u&&u.type.indexOf("tag-name")===-1;)u=r.stepBackward();if(!u)return;var x=u.value,v=r.getCurrentTokenRow();if(u=r.stepBackward(),!u||u.type.indexOf("end-tag")!==-1)return;if(this.voidElements&&!this.voidElements[x]){var k=o.getTokenAt(e.row,e.column+1),a=o.getLine(v),y=this.$getIndent(a),w=y+o.getTabString();return k&&k.value==="</"?{text:`
`+w+`
`+y,selection:[1,w.length,1,w.length]}:{text:`
`+w}}}}})};f.inherits(g,m),h.XmlBehaviour=g}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(s,h,b){"use strict";var f=s("../../lib/oop"),m=s("./fold_mode").FoldMode,p=h.FoldMode=function(c,n){this.defaultMode=c,this.subModes=n};f.inherits(p,m),function(){this.$getMode=function(c){typeof c!="string"&&(c=c[0]);for(var n in this.subModes)if(c.indexOf(n)===0)return this.subModes[n];return null},this.$tryMode=function(c,n,g,l){var d=this.$getMode(c);return d?d.getFoldWidget(n,g,l):""},this.getFoldWidget=function(c,n,g){return this.$tryMode(c.getState(g-1),c,n,g)||this.$tryMode(c.getState(g),c,n,g)||this.defaultMode.getFoldWidget(c,n,g)},this.getFoldWidgetRange=function(c,n,g){var l=this.$getMode(c.getState(g-1));return(!l||!l.getFoldWidget(c,n,g))&&(l=this.$getMode(c.getState(g))),(!l||!l.getFoldWidget(c,n,g))&&(l=this.defaultMode),l.getFoldWidgetRange(c,n,g)}}.call(p.prototype)}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],function(s,h,b){"use strict";var f=s("../../lib/oop"),m=s("../../lib/lang"),p=s("../../range").Range,c=s("./fold_mode").FoldMode,n=s("../../token_iterator").TokenIterator,g=h.FoldMode=function(i,o){c.call(this),this.voidElements=i||{},this.optionalEndTags=f.mixin({},this.voidElements),o&&f.mixin(this.optionalEndTags,o)};f.inherits(g,c);var l=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function d(i,o){return i.type.lastIndexOf(o+".xml")>-1}(function(){this.getFoldWidget=function(i,o,t){var e=this._getFirstTagInLine(i,t);return e?e.closing||!e.tagName&&e.selfClosing?o=="markbeginend"?"end":"":!e.tagName||e.selfClosing||this.voidElements.hasOwnProperty(e.tagName.toLowerCase())||this._findEndTagInLine(i,t,e.tagName,e.end.column)?"":"start":this.getCommentFoldWidget(i,t)},this.getCommentFoldWidget=function(i,o){return/comment/.test(i.getState(o))&&/<!-/.test(i.getLine(o))?"start":""},this._getFirstTagInLine=function(i,o){for(var t=i.getTokens(o),e=new l,a=0;a<t.length;a++){var r=t[a];if(d(r,"tag-open")){if(e.end.column=e.start.column+r.value.length,e.closing=d(r,"end-tag-open"),r=t[++a],!r)return null;for(e.tagName=r.value,e.end.column+=r.value.length,a++;a<t.length;a++)if(r=t[a],e.end.column+=r.value.length,d(r,"tag-close")){e.selfClosing=r.value=="/>";break}return e}else if(d(r,"tag-close"))return e.selfClosing=r.value=="/>",e;e.start.column+=r.value.length}return null},this._findEndTagInLine=function(i,o,t,e){for(var a=i.getTokens(o),r=0,u=0;u<a.length;u++){var x=a[u];if(r+=x.value.length,!(r<e)&&d(x,"end-tag-open")&&(x=a[u+1],x&&x.value==t))return!0}return!1},this._readTagForward=function(i){var o=i.getCurrentToken();if(!o)return null;var t=new l;do if(d(o,"tag-open"))t.closing=d(o,"end-tag-open"),t.start.row=i.getCurrentTokenRow(),t.start.column=i.getCurrentTokenColumn();else if(d(o,"tag-name"))t.tagName=o.value;else if(d(o,"tag-close"))return t.selfClosing=o.value=="/>",t.end.row=i.getCurrentTokenRow(),t.end.column=i.getCurrentTokenColumn()+o.value.length,i.stepForward(),t;while(o=i.stepForward());return null},this._readTagBackward=function(i){var o=i.getCurrentToken();if(!o)return null;var t=new l;do{if(d(o,"tag-open"))return t.closing=d(o,"end-tag-open"),t.start.row=i.getCurrentTokenRow(),t.start.column=i.getCurrentTokenColumn(),i.stepBackward(),t;d(o,"tag-name")?t.tagName=o.value:d(o,"tag-close")&&(t.selfClosing=o.value=="/>",t.end.row=i.getCurrentTokenRow(),t.end.column=i.getCurrentTokenColumn()+o.value.length)}while(o=i.stepBackward());return null},this._pop=function(i,o){for(;i.length;){var t=i[i.length-1];if(!o||t.tagName==o.tagName)return i.pop();if(this.optionalEndTags.hasOwnProperty(t.tagName)){i.pop();continue}else return null}},this.getFoldWidgetRange=function(i,o,t){var e=this._getFirstTagInLine(i,t);if(!e)return this.getCommentFoldWidget(i,t)&&i.getCommentFoldRange(t,i.getLine(t).length);var a=e.closing||e.selfClosing,r=[],u;if(a)for(var x=new n(i,t,e.end.column),k={row:t,column:e.start.column};u=this._readTagBackward(x);){if(u.selfClosing){if(r.length)continue;return u.start.column+=u.tagName.length+2,u.end.column-=2,p.fromPoints(u.start,u.end)}if(u.closing)r.push(u);else if(this._pop(r,u),r.length==0)return u.start.column+=u.tagName.length+2,u.start.row==u.end.row&&u.start.column<u.end.column&&(u.start.column=u.end.column),p.fromPoints(u.start,k)}else{var x=new n(i,t,e.start.column),v={row:t,column:e.start.column+e.tagName.length+2};for(e.start.row==e.end.row&&(v.column=e.end.column);u=this._readTagForward(x);){if(u.selfClosing){if(r.length)continue;return u.start.column+=u.tagName.length+2,u.end.column-=2,p.fromPoints(u.start,u.end)}if(u.closing){if(this._pop(r,u),r.length==0)return p.fromPoints(v,u.start)}else r.push(u)}}}}).call(g.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(s,h,b){"use strict";var f=s("../../lib/oop"),m=s("./mixed").FoldMode,p=s("./xml").FoldMode,c=s("./cstyle").FoldMode,n=h.FoldMode=function(g,l){m.call(this,new p(g,l),{"js-":new c,"css-":new c})};f.inherits(n,m)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(s,h,b){"use strict";var f=s("../token_iterator").TokenIterator,m=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"],p=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"],c=m.concat(p),n={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},g=Object.keys(n);function l(t,e){return t.type.lastIndexOf(e+".xml")>-1}function d(t,e){for(var a=new f(t,e.row,e.column),r=a.getCurrentToken();r&&!l(r,"tag-name");)r=a.stepBackward();if(r)return r.value}function i(t,e){for(var a=new f(t,e.row,e.column),r=a.getCurrentToken();r&&!l(r,"attribute-name");)r=a.stepBackward();if(r)return r.value}var o=function(){};(function(){this.getCompletions=function(t,e,a,r){var u=e.getTokenAt(a.row,a.column);if(!u)return[];if(l(u,"tag-name")||l(u,"tag-open")||l(u,"end-tag-open"))return this.getTagCompletions(t,e,a,r);if(l(u,"tag-whitespace")||l(u,"attribute-name"))return this.getAttributeCompletions(t,e,a,r);if(l(u,"attribute-value"))return this.getAttributeValueCompletions(t,e,a,r);var x=e.getLine(a.row).substr(0,a.column);return/&[a-z]*$/i.test(x)?this.getHTMLEntityCompletions(t,e,a,r):[]},this.getTagCompletions=function(t,e,a,r){return g.map(function(u){return{value:u,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(t,e,a,r){var u=d(e,a);if(!u)return[];var x=c;return u in n&&(x=x.concat(Object.keys(n[u]))),x.map(function(v){return{caption:v,snippet:v+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(t,e,a,r){var u=d(e,a),x=i(e,a);if(!u)return[];var v=[];return u in n&&x in n[u]&&typeof n[u][x]=="object"&&(v=Object.keys(n[u][x])),v.map(function(k){return{caption:k,snippet:k,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(t,e,a,r){var u=["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"];return u.map(function(x){return{caption:x,snippet:x,meta:"html entity",score:1e6}})}}).call(o.prototype),h.HtmlCompletions=o}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("../lib/lang"),p=s("./text").Mode,c=s("./javascript").Mode,n=s("./css").Mode,g=s("./html_highlight_rules").HtmlHighlightRules,l=s("./behaviour/xml").XmlBehaviour,d=s("./folding/html").FoldMode,i=s("./html_completions").HtmlCompletions,o=s("../worker/worker_client").WorkerClient,t=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],e=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],a=function(r){this.fragmentContext=r&&r.fragmentContext,this.HighlightRules=g,this.$behaviour=new l,this.$completer=new i,this.createModeDelegates({"js-":c,"css-":n}),this.foldingRules=new d(this.voidElements,m.arrayToMap(e))};f.inherits(a,p),function(){this.blockComment={start:"<!--",end:"-->"},this.voidElements=m.arrayToMap(t),this.getNextLineIndent=function(r,u,x){return this.$getIndent(u)},this.checkOutdent=function(r,u,x){return!1},this.getCompletions=function(r,u,x,v){return this.$completer.getCompletions(r,u,x,v)},this.createWorker=function(r){if(this.constructor==a){var u=new o(["ace"],"ace/mode/html_worker","Worker");return u.attachToDocument(r.getDocument()),this.fragmentContext&&u.call("setOptions",[{context:this.fragmentContext}]),u.on("error",function(x){r.setAnnotations(x.data)}),u.on("terminate",function(){r.clearAnnotations()}),u}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(a.prototype),h.Mode=a}),ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(s,h,b){"use strict";var f=s("../../lib/oop"),m=s("./fold_mode").FoldMode,p=s("../../range").Range,c=h.FoldMode=function(){};f.inherits(c,m),function(){this.getFoldWidgetRange=function(n,g,l){var d=this.indentationBlock(n,l);if(d)return d;var i=/\S/,o=n.getLine(l),t=o.search(i);if(!(t==-1||o[t]!="#")){for(var e=o.length,a=n.getLength(),r=l,u=l;++l<a;){o=n.getLine(l);var x=o.search(i);if(x!=-1){if(o[x]!="#")break;u=l}}if(u>r){var v=n.getLine(u).length;return new p(r,e,u,v)}}},this.getFoldWidget=function(n,g,l){var d=n.getLine(l),i=d.search(/\S/),o=n.getLine(l+1),t=n.getLine(l-1),e=t.search(/\S/),a=o.search(/\S/);if(i==-1)return n.foldWidgets[l-1]=e!=-1&&e<a?"start":"","";if(e==-1){if(i==a&&d[i]=="#"&&o[i]=="#")return n.foldWidgets[l-1]="",n.foldWidgets[l+1]="","start"}else if(e==i&&d[i]=="#"&&t[i]=="#"&&n.getLine(l-2).search(/\S/)==-1)return n.foldWidgets[l-1]="start",n.foldWidgets[l+1]="","";return e!=-1&&e<i?n.foldWidgets[l-1]="start":n.foldWidgets[l-1]="",i<a?"start":""}}.call(c.prototype)}),ace.define("ace/mode/elixir",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/elixir_highlight_rules","ace/mode/folding/coffee"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./text").Mode,p=s("./elixir_highlight_rules").ElixirHighlightRules,c=s("./folding/coffee").FoldMode,n=function(){this.HighlightRules=p,this.foldingRules=new c,this.$behaviour=this.$defaultBehaviour};f.inherits(n,m),function(){this.lineCommentStart="#",this.$id="ace/mode/elixir"}.call(n.prototype),h.Mode=n}),ace.define("ace/mode/html_elixir",["require","exports","module","ace/lib/oop","ace/mode/html_elixir_highlight_rules","ace/mode/html","ace/mode/javascript","ace/mode/css","ace/mode/elixir"],function(s,h,b){"use strict";var f=s("../lib/oop"),m=s("./html_elixir_highlight_rules").HtmlElixirHighlightRules,p=s("./html").Mode,c=s("./javascript").Mode,n=s("./css").Mode,g=s("./elixir").Mode,l=function(){p.call(this),this.HighlightRules=m,this.createModeDelegates({"js-":c,"css-":n,"elixir-":g})};f.inherits(l,p),function(){this.$id="ace/mode/html_elixir"}.call(l.prototype),h.Mode=l}),function(){ace.require(["ace/mode/html_elixir"],function(s){typeof module=="object"&&typeof exports=="object"&&module&&(module.exports=s)})}();
