ace.define("ace/mode/slim_highlight_rules",["require","exports","module","ace/config","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../config").$modes,f=r("../lib/oop"),h=r("./text_highlight_rules").TextHighlightRules,g=function(){this.$rules={start:[{token:"keyword",regex:/^(\s*)(\w+):\s*/,onMatch:function(i,c,l,s){var a=/^\s*/.exec(s)[0],e=i.match(/^(\s*)(\w+):/),t=e[2];return/^(javascript|ruby|coffee|markdown|css|scss|sass|less)$/.test(t)||(t=""),l.unshift("language-embed",[],[a,t],c),this.token},stateName:"language-embed",next:[{token:"string",regex:/^(\s*)/,onMatch:function(i,c,l,s){var a=l[2][0];return a.length>=i.length?(l.splice(0,3),this.next=l.shift(),this.token):(this.next="",[{type:"text",value:a}])},next:""},{token:"string",regex:/.+/,onMatch:function(i,c,l,s){var a=l[2][0],e=l[2][1],t=l[1];if(x[e]){var n=x[e].getTokenizer().getLineTokens(s.slice(a.length),t.slice(0));return l[1]=n.state,n.tokens}return this.token}}]},{token:"constant.begin.javascript.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(ruby):$"},{token:"constant.begin.coffeescript.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(markdown):$"},{token:"constant.begin.css.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin.scss.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(sass):$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(less):$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(erb):$"},{token:"keyword.html.tags.slim",regex:"^(\\s*)((:?\\*(\\w)+)|doctype html|abbr|acronym|address|applet|area|article|aside|audio|base|basefont|bdo|big|blockquote|body|br|button|canvas|caption|center|cite|code|col|colgroup|command|datalist|dd|del|details|dialog|dfn|dir|div|dl|dt|embed|fieldset|figure|font|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|i|iframe|img|input|ins|keygen|kbd|label|legend|link|li|map|mark|menu|meta|meter|nav|noframes|noscript|object|ol|optgroup|option|output|p|param|pre|progress|q|rp|rt|ruby|samp|script|section|select|small|source|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|time|title|tr|tt|ul|var|video|xmp|b|u|s|em|a)(?:([.#](\\w|\\.)+)+\\s?)?\\b"},{token:"keyword.slim",regex:"^(\\s*)(?:([.#](\\w|\\.)+)+\\s?)"},{token:"string",regex:/^(\s*)('|\||\/|(\/!))\s*/,onMatch:function(i,c,l,s){var a=/^\s*/.exec(s)[0];return l.length<1?l.push(this.next):l[0]="mlString",l.length<2?l.push(a.length):l[1]=a.length,this.token},next:"mlString"},{token:"keyword.control.slim",regex:"^(\\s*)(\\-|==|=)",push:[{token:"control.end.slim",regex:"$",next:"pop"},{include:"rubyline"},{include:"misc"}]},{token:"paren",regex:"\\(",push:[{token:"paren",regex:"\\)",next:"pop"},{include:"misc"}]},{token:"paren",regex:"\\[",push:[{token:"paren",regex:"\\]",next:"pop"},{include:"misc"}]},{include:"misc"}],mlString:[{token:"indent",regex:/^\s*/,onMatch:function(i,c,l){var s=l[1];return s>=i.length?(this.next="start",l.splice(0)):this.next="mlString",this.token},next:"start"},{defaultToken:"string"}],rubyline:[{token:"keyword.operator.ruby.embedded.slim",regex:"(==|=)(<>|><|<'|'<|<|>)?|-"},{token:"list.ruby.operators.slim",regex:"(\\b)(for|in|do|if|else|elsif|unless|while|yield|not|and|or)\\b"},{token:"string",regex:"['](.)*?[']"},{token:"string",regex:'["](.)*?["]'}],misc:[{token:"class.variable.slim",regex:"\\@([a-zA-Z_][a-zA-Z0-9_]*)\\b"},{token:"list.meta.slim",regex:"(\\b)(true|false|nil)(\\b)"},{token:"keyword.operator.equals.slim",regex:"="},{token:"string",regex:"['](.)*?[']"},{token:"string",regex:'["](.)*?["]'}]},this.normalizeRules()};f.inherits(g,h),m.SlimHighlightRules=g}),ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,h=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},h.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:!0}]}};x.inherits(h,f),h.getTagRule=function(g){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},h.getStartRule=function(g){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:g}},h.getEndRule=function(g){return{token:"comment.doc",regex:"\\*\\/",next:g}},m.DocCommentHighlightRules=h}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./doc_comment_highlight_rules").DocCommentHighlightRules,h=r("./text_highlight_rules").TextHighlightRules,g="[a-zA-Z\\$_\xA1-\uFFFF][a-zA-Z\\d\\$_\xA1-\uFFFF]*",i=function(s){var a=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier"),e="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void",t="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)";this.$rules={no_regex:[f.getStartRule("doc-start"),l("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+g+")(\\.)(prototype)(\\.)("+g+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+g+")(\\.)("+g+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+g+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+g+")(\\.)("+g+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+g+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+g+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:`from(?=\\s*('|"))`},{token:"keyword",regex:"(?:"+e+")\\b",next:"start"},{token:["support.constant"],regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:a,regex:g},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+g+")(\\.)("+g+")(\\s*)(=)(\\s*)(function)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:g},{regex:"",token:"empty",next:"no_regex"}],start:[f.getStartRule("doc-start"),l("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],function_arguments:[{token:"variable.parameter",regex:g},{token:"punctuation.operator",regex:"[, ]+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!s||!s.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(n,o,u){if(this.next=n=="{"?this.nextState:"",n=="{"&&u.length)u.unshift("start",o);else if(n=="}"&&u.length&&(u.shift(),this.next=u.shift(),this.next.indexOf("string")!=-1||this.next.indexOf("jsx")!=-1))return"paren.quasi.end";return n=="{"?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:t},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]}),(!s||s.jsx!=!1)&&c.call(this)),this.embedRules(f,"doc-",[f.getEndRule("no_regex")]),this.normalizeRules()};x.inherits(i,h);function c(){var s=g.replace("\\d","\\d\\-"),a={onMatch:function(t,n,o){var u=t.charAt(1)=="/"?2:1;return u==1?(n!=this.nextState?o.unshift(this.next,this.nextState,0):o.unshift(this.next),o[2]++):u==2&&n==this.nextState&&(o[1]--,(!o[1]||o[1]<0)&&(o.shift(),o.shift())),[{type:"meta.tag.punctuation."+(u==1?"":"end-")+"tag-open.xml",value:t.slice(0,u)},{type:"meta.tag.tag-name.xml",value:t.substr(u)}]},regex:"</?"+s,next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(a);var e={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[e,a,{include:"reference"},{defaultToken:"string"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(t,n,o){return n==o[0]&&o.shift(),t.length==2&&(o[0]==this.nextState&&o[1]--,(!o[1]||o[1]<0)&&o.splice(0,2)),this.next=o[0]||"start",[{type:this.token,value:t}]},nextState:"jsx"},e,l("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:s},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},a],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function l(s){return[{token:"comment",regex:/\/\*/,next:[f.getTagRule(),{token:"comment",regex:"\\*\\/",next:s||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[f.getTagRule(),{token:"comment",regex:"$|^",next:s||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}m.JavaScriptHighlightRules=i}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(r,m,_){"use strict";var x=r("../range").Range,f=function(){};(function(){this.checkOutdent=function(h,g){return/^\s+$/.test(h)?/^\s*\}/.test(g):!1},this.autoOutdent=function(h,g){var i=h.getLine(g),c=i.match(/^(\s*\})/);if(!c)return 0;var l=c[1].length,s=h.findMatchingBracket({row:g,column:l});if(!s||s.row==g)return 0;var a=this.$getIndent(h.getLine(s.row));h.replace(new x(g,0,g,l-1),a)},this.$getIndent=function(h){return h.match(/^\s*/)[0]}}).call(f.prototype),m.MatchingBraceOutdent=f}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("../../range").Range,h=r("./fold_mode").FoldMode,g=m.FoldMode=function(i){i&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+i.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+i.end)))};x.inherits(g,h),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(i,c,l){var s=i.getLine(l);if(this.singleLineBlockCommentRe.test(s)&&!this.startRegionRe.test(s)&&!this.tripleStarBlockCommentRe.test(s))return"";var a=this._getFoldWidgetBase(i,c,l);return!a&&this.startRegionRe.test(s)?"start":a},this.getFoldWidgetRange=function(i,c,l,s){var a=i.getLine(l);if(this.startRegionRe.test(a))return this.getCommentRegionBlock(i,a,l);var n=a.match(this.foldingStartMarker);if(n){var e=n.index;if(n[1])return this.openingBracketBlock(i,n[1],l,e);var t=i.getCommentFoldRange(l,e+n[0].length,1);return t&&!t.isMultiLine()&&(s?t=this.getSectionRange(i,l):c!="all"&&(t=null)),t}if(c!=="markbegin"){var n=a.match(this.foldingStopMarker);if(n){var e=n.index+n[0].length;return n[1]?this.closingBracketBlock(i,n[1],l,e):i.getCommentFoldRange(l,e,-1)}}},this.getSectionRange=function(i,c){var l=i.getLine(c),s=l.search(/\S/),a=c,e=l.length;c=c+1;for(var t=c,n=i.getLength();++c<n;){l=i.getLine(c);var o=l.search(/\S/);if(o!==-1){if(s>o)break;var u=this.getFoldWidgetRange(i,"all",c);if(u){if(u.start.row<=a)break;if(u.isMultiLine())c=u.end.row;else if(s==o)break}t=c}}return new f(a,e,t,i.getLine(t).length)},this.getCommentRegionBlock=function(i,c,l){for(var s=c.search(/\s*$/),a=i.getLength(),e=l,t=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,n=1;++l<a;){c=i.getLine(l);var o=t.exec(c);if(o&&(o[1]?n--:n++,!n))break}var u=l;if(u>e)return new f(e,s,u,c.length)}}.call(g.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./javascript_highlight_rules").JavaScriptHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,i=r("../worker/worker_client").WorkerClient,c=r("./behaviour/cstyle").CstyleBehaviour,l=r("./folding/cstyle").FoldMode,s=function(){this.HighlightRules=h,this.$outdent=new g,this.$behaviour=new c,this.foldingRules=new l};x.inherits(s,f),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.getNextLineIndent=function(a,e,t){var n=this.$getIndent(e),o=this.getTokenizer().getLineTokens(e,a),u=o.tokens,d=o.state;if(u.length&&u[u.length-1].type=="comment")return n;if(a=="start"||a=="no_regex"){var b=e.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);b&&(n+=t)}else if(a=="doc-start"){if(d=="start"||d=="no_regex")return"";var b=e.match(/^\s*(\/?)\*/);b&&(b[1]&&(n+=" "),n+="* ")}return n},this.checkOutdent=function(a,e,t){return this.$outdent.checkOutdent(e,t)},this.autoOutdent=function(a,e,t){this.$outdent.autoOutdent(e,t)},this.createWorker=function(a){var e=new i(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return e.attachToDocument(a.getDocument()),e.on("annotate",function(t){a.setAnnotations(t.data)}),e.on("terminate",function(){a.clearAnnotations()}),e},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(s.prototype),m.Mode=s}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,h=function(g){var i="[_:a-zA-Z\xC0-\uFFFF][-_:.a-zA-Z0-9\xC0-\uFFFF]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+i+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:i},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+i+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"-->",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+i+":)?"+i+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:i},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===h&&this.normalizeRules()};(function(){this.embedTagRules=function(g,i,c){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+c+".tag-name.xml"],regex:"(<)("+c+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:i+"start"}]}),this.$rules[c+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(l,s,a){return a.splice(0),this.token}}],this.embedRules(g,i,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+c+".tag-name.xml"],regex:"(</)("+c+"(?=\\s|>|$))",next:c+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(f.prototype),x.inherits(h,f),m.XmlHighlightRules=h}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("../behaviour").Behaviour,h=r("../../token_iterator").TokenIterator,g=r("../../lib/lang");function i(l,s){return l&&l.type.lastIndexOf(s+".xml")>-1}var c=function(){this.add("string_dquotes","insertion",function(l,s,a,e,t){if(t=='"'||t=="'"){var n=t,o=e.doc.getTextRange(a.getSelectionRange());if(o!==""&&o!=="'"&&o!='"'&&a.getWrapBehavioursEnabled())return{text:n+o+n,selection:!1};var u=a.getCursorPosition(),d=e.doc.getLine(u.row),b=d.substring(u.column,u.column+1),w=new h(e,u.row,u.column),k=w.getCurrentToken();if(b==n&&(i(k,"attribute-value")||i(k,"string")))return{text:"",selection:[1,1]};if(k||(k=w.stepBackward()),!k)return;for(;i(k,"tag-whitespace")||i(k,"whitespace");)k=w.stepBackward();var R=!b||b.match(/\s/);if(i(k,"attribute-equals")&&(R||b==">")||i(k,"decl-attribute-equals")&&(R||b=="?"))return{text:n+n,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(l,s,a,e,t){var n=e.doc.getTextRange(t);if(!t.isMultiLine()&&(n=='"'||n=="'")){var o=e.doc.getLine(t.start.row),u=o.substring(t.start.column+1,t.start.column+2);if(u==n)return t.end.column++,t}}),this.add("autoclosing","insertion",function(l,s,a,e,t){if(t==">"){var n=a.getSelectionRange().start,o=new h(e,n.row,n.column),u=o.getCurrentToken()||o.stepBackward();if(!u||!(i(u,"tag-name")||i(u,"tag-whitespace")||i(u,"attribute-name")||i(u,"attribute-equals")||i(u,"attribute-value"))||i(u,"reference.attribute-value"))return;if(i(u,"attribute-value")){var d=o.getCurrentTokenColumn()+u.value.length;if(n.column<d)return;if(n.column==d){var b=o.stepForward();if(b&&i(b,"attribute-value"))return;o.stepBackward()}}if(/^\s*>/.test(e.getLine(n.row).slice(n.column)))return;for(;!i(u,"tag-name");)if(u=o.stepBackward(),u.value=="<"){u=o.stepForward();break}var w=o.getCurrentTokenRow(),k=o.getCurrentTokenColumn();if(i(o.stepBackward(),"end-tag-open"))return;var R=u.value;return w==n.row&&(R=R.substring(0,n.column-k)),this.voidElements.hasOwnProperty(R.toLowerCase())?void 0:{text:"></"+R+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(l,s,a,e,t){if(t==`
`){var n=a.getCursorPosition(),o=e.getLine(n.row),u=new h(e,n.row,n.column),d=u.getCurrentToken();if(d&&d.type.indexOf("tag-close")!==-1){if(d.value=="/>")return;for(;d&&d.type.indexOf("tag-name")===-1;)d=u.stepBackward();if(!d)return;var b=d.value,w=u.getCurrentTokenRow();if(d=u.stepBackward(),!d||d.type.indexOf("end-tag")!==-1)return;if(this.voidElements&&!this.voidElements[b]){var k=e.getTokenAt(n.row,n.column+1),o=e.getLine(w),R=this.$getIndent(o),v=R+e.getTabString();return k&&k.value==="</"?{text:`
`+v+`
`+R,selection:[1,v.length,1,v.length]}:{text:`
`+v}}}}})};x.inherits(c,f),m.XmlBehaviour=c}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("../../lib/lang"),h=r("../../range").Range,g=r("./fold_mode").FoldMode,i=r("../../token_iterator").TokenIterator,c=m.FoldMode=function(a,e){g.call(this),this.voidElements=a||{},this.optionalEndTags=x.mixin({},this.voidElements),e&&x.mixin(this.optionalEndTags,e)};x.inherits(c,g);var l=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function s(a,e){return a.type.lastIndexOf(e+".xml")>-1}(function(){this.getFoldWidget=function(a,e,t){var n=this._getFirstTagInLine(a,t);return n?n.closing||!n.tagName&&n.selfClosing?e=="markbeginend"?"end":"":!n.tagName||n.selfClosing||this.voidElements.hasOwnProperty(n.tagName.toLowerCase())||this._findEndTagInLine(a,t,n.tagName,n.end.column)?"":"start":this.getCommentFoldWidget(a,t)},this.getCommentFoldWidget=function(a,e){return/comment/.test(a.getState(e))&&/<!-/.test(a.getLine(e))?"start":""},this._getFirstTagInLine=function(a,e){for(var t=a.getTokens(e),n=new l,o=0;o<t.length;o++){var u=t[o];if(s(u,"tag-open")){if(n.end.column=n.start.column+u.value.length,n.closing=s(u,"end-tag-open"),u=t[++o],!u)return null;for(n.tagName=u.value,n.end.column+=u.value.length,o++;o<t.length;o++)if(u=t[o],n.end.column+=u.value.length,s(u,"tag-close")){n.selfClosing=u.value=="/>";break}return n}else if(s(u,"tag-close"))return n.selfClosing=u.value=="/>",n;n.start.column+=u.value.length}return null},this._findEndTagInLine=function(a,e,t,n){for(var o=a.getTokens(e),u=0,d=0;d<o.length;d++){var b=o[d];if(u+=b.value.length,!(u<n)&&s(b,"end-tag-open")&&(b=o[d+1],b&&b.value==t))return!0}return!1},this._readTagForward=function(a){var e=a.getCurrentToken();if(!e)return null;var t=new l;do if(s(e,"tag-open"))t.closing=s(e,"end-tag-open"),t.start.row=a.getCurrentTokenRow(),t.start.column=a.getCurrentTokenColumn();else if(s(e,"tag-name"))t.tagName=e.value;else if(s(e,"tag-close"))return t.selfClosing=e.value=="/>",t.end.row=a.getCurrentTokenRow(),t.end.column=a.getCurrentTokenColumn()+e.value.length,a.stepForward(),t;while(e=a.stepForward());return null},this._readTagBackward=function(a){var e=a.getCurrentToken();if(!e)return null;var t=new l;do{if(s(e,"tag-open"))return t.closing=s(e,"end-tag-open"),t.start.row=a.getCurrentTokenRow(),t.start.column=a.getCurrentTokenColumn(),a.stepBackward(),t;s(e,"tag-name")?t.tagName=e.value:s(e,"tag-close")&&(t.selfClosing=e.value=="/>",t.end.row=a.getCurrentTokenRow(),t.end.column=a.getCurrentTokenColumn()+e.value.length)}while(e=a.stepBackward());return null},this._pop=function(a,e){for(;a.length;){var t=a[a.length-1];if(!e||t.tagName==e.tagName)return a.pop();if(this.optionalEndTags.hasOwnProperty(t.tagName)){a.pop();continue}else return null}},this.getFoldWidgetRange=function(a,e,t){var n=this._getFirstTagInLine(a,t);if(!n)return this.getCommentFoldWidget(a,t)&&a.getCommentFoldRange(t,a.getLine(t).length);var o=n.closing||n.selfClosing,u=[],d;if(o)for(var b=new i(a,t,n.end.column),k={row:t,column:n.start.column};d=this._readTagBackward(b);){if(d.selfClosing){if(u.length)continue;return d.start.column+=d.tagName.length+2,d.end.column-=2,h.fromPoints(d.start,d.end)}if(d.closing)u.push(d);else if(this._pop(u,d),u.length==0)return d.start.column+=d.tagName.length+2,d.start.row==d.end.row&&d.start.column<d.end.column&&(d.start.column=d.end.column),h.fromPoints(d.start,k)}else{var b=new i(a,t,n.start.column),w={row:t,column:n.start.column+n.tagName.length+2};for(n.start.row==n.end.row&&(w.column=n.end.column);d=this._readTagForward(b);){if(d.selfClosing){if(u.length)continue;return d.start.column+=d.tagName.length+2,d.end.column-=2,h.fromPoints(d.start,d.end)}if(d.closing){if(this._pop(u,d),u.length==0)return h.fromPoints(w,d.start)}else u.push(d)}}}}).call(c.prototype)}),ace.define("ace/mode/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/xml_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/xml","ace/worker/worker_client"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),h=r("./text").Mode,g=r("./xml_highlight_rules").XmlHighlightRules,i=r("./behaviour/xml").XmlBehaviour,c=r("./folding/xml").FoldMode,l=r("../worker/worker_client").WorkerClient,s=function(){this.HighlightRules=g,this.$behaviour=new i,this.foldingRules=new c};x.inherits(s,h),function(){this.voidElements=f.arrayToMap([]),this.blockComment={start:"<!--",end:"-->"},this.createWorker=function(a){var e=new l(["ace"],"ace/mode/xml_worker","Worker");return e.attachToDocument(a.getDocument()),e.on("error",function(t){a.setAnnotations(t.data)}),e.on("terminate",function(){a.clearAnnotations()}),e},this.$id="ace/mode/xml"}.call(s.prototype),m.Mode=s}),ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),h=r("./text_highlight_rules").TextHighlightRules,g=m.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",i=m.supportFunction="rgb|rgba|url|attr|counter|counters",c=m.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",l=m.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",s=m.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",a=m.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",e=m.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",t=m.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",n=function(){var o=this.createKeywordMapper({"support.function":i,"support.constant":c,"support.type":g,"support.constant.color":l,"support.constant.fonts":s},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:a},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+a+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:a},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:e},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:t},{include:"url"},{token:o,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};x.inherits(n,h),m.CssHighlightRules=n}),ace.define("ace/mode/css_completions",["require","exports","module"],function(r,m,_){"use strict";var x={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},f=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var h=document.createElement("c").style;for(var g in h)if(typeof h[g]=="string"){var i=g.replace(/[A-Z]/g,function(c){return"-"+c.toLowerCase()});x.hasOwnProperty(i)||(x[i]=1)}}this.completionsDefined=!0},this.getCompletions=function(h,g,i,c){if(this.completionsDefined||this.defineCompletions(),h==="ruleset"||g.$mode.$id=="ace/mode/scss"){var l=g.getLine(i.row).substr(0,i.column);return/:[^;]+$/.test(l)?(/([\w\-]+):[^:]*$/.test(l),this.getPropertyValueCompletions(h,g,i,c)):this.getPropertyCompletions(h,g,i,c)}return[]},this.getPropertyCompletions=function(h,g,i,c){var l=Object.keys(x);return l.map(function(s){return{caption:s,snippet:s+": $0;",meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(h,g,i,c){var l=g.getLine(i.row).substr(0,i.column),s=(/([\w\-]+):[^:]*$/.exec(l)||{})[1];if(!s)return[];var a=[];return s in x&&typeof x[s]=="object"&&(a=Object.keys(x[s])),a.map(function(e){return{caption:e,snippet:e,meta:"property value",score:1e6}})}}).call(f.prototype),m.CssCompletions=f}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("../behaviour").Behaviour,h=r("./cstyle").CstyleBehaviour,g=r("../../token_iterator").TokenIterator,i=function(){this.inherit(h),this.add("colon","insertion",function(c,l,s,a,e){if(e===":"&&s.selection.isEmpty()){var t=s.getCursorPosition(),n=new g(a,t.row,t.column),o=n.getCurrentToken();if(o&&o.value.match(/\s+/)&&(o=n.stepBackward()),o&&o.type==="support.type"){var u=a.doc.getLine(t.row),d=u.substring(t.column,t.column+1);if(d===":")return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(u.substring(t.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(c,l,s,a,e){var t=a.doc.getTextRange(e);if(!e.isMultiLine()&&t===":"){var n=s.getCursorPosition(),o=new g(a,n.row,n.column),u=o.getCurrentToken();if(u&&u.value.match(/\s+/)&&(u=o.stepBackward()),u&&u.type==="support.type"){var d=a.doc.getLine(e.start.row),b=d.substring(e.end.column,e.end.column+1);if(b===";")return e.end.column++,e}}}),this.add("semicolon","insertion",function(c,l,s,a,e){if(e===";"&&s.selection.isEmpty()){var t=s.getCursorPosition(),n=a.doc.getLine(t.row),o=n.substring(t.column,t.column+1);if(o===";")return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(c,l,s,a,e){if(e==="!"&&s.selection.isEmpty()){var t=s.getCursorPosition(),n=a.doc.getLine(t.row);if(/^\s*(;|}|$)/.test(n.substring(t.column)))return{text:"!important",selection:[10,10]}}})};x.inherits(i,h),m.CssBehaviour=i}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./css_highlight_rules").CssHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,i=r("../worker/worker_client").WorkerClient,c=r("./css_completions").CssCompletions,l=r("./behaviour/css").CssBehaviour,s=r("./folding/cstyle").FoldMode,a=function(){this.HighlightRules=h,this.$outdent=new g,this.$behaviour=new l,this.$completer=new c,this.foldingRules=new s};x.inherits(a,f),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(e,t,n){var o=this.$getIndent(t),u=this.getTokenizer().getLineTokens(t,e).tokens;if(u.length&&u[u.length-1].type=="comment")return o;var d=t.match(/^.*\{\s*$/);return d&&(o+=n),o},this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)},this.getCompletions=function(e,t,n,o){return this.$completer.getCompletions(e,t,n,o)},this.createWorker=function(e){var t=new i(["ace"],"ace/mode/css_worker","Worker");return t.attachToDocument(e.getDocument()),t.on("annotate",function(n){e.setAnnotations(n.data)}),t.on("terminate",function(){e.clearAnnotations()}),t},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(a.prototype),m.Mode=a}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),h=r("./css_highlight_rules").CssHighlightRules,g=r("./javascript_highlight_rules").JavaScriptHighlightRules,i=r("./xml_highlight_rules").XmlHighlightRules,c=f.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),l=function(){i.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(s,a){var e=c[a];return["meta.tag.punctuation."+(s=="<"?"":"end-")+"tag-open.xml","meta.tag"+(e?"."+e:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(h,"css-","style"),this.embedTagRules(new g({jsx:!1}).getRules(),"js-","script"),this.constructor===l&&this.normalizeRules()};x.inherits(l,i),m.HtmlHighlightRules=l}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,h=m.FoldMode=function(g,i){this.defaultMode=g,this.subModes=i};x.inherits(h,f),function(){this.$getMode=function(g){typeof g!="string"&&(g=g[0]);for(var i in this.subModes)if(g.indexOf(i)===0)return this.subModes[i];return null},this.$tryMode=function(g,i,c,l){var s=this.$getMode(g);return s?s.getFoldWidget(i,c,l):""},this.getFoldWidget=function(g,i,c){return this.$tryMode(g.getState(c-1),g,i,c)||this.$tryMode(g.getState(c),g,i,c)||this.defaultMode.getFoldWidget(g,i,c)},this.getFoldWidgetRange=function(g,i,c){var l=this.$getMode(g.getState(c-1));return(!l||!l.getFoldWidget(g,i,c))&&(l=this.$getMode(g.getState(c))),(!l||!l.getFoldWidget(g,i,c))&&(l=this.defaultMode),l.getFoldWidgetRange(g,i,c)}}.call(h.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("./mixed").FoldMode,h=r("./xml").FoldMode,g=r("./cstyle").FoldMode,i=m.FoldMode=function(c,l){f.call(this,new h(c,l),{"js-":new g,"css-":new g})};x.inherits(i,f)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(r,m,_){"use strict";var x=r("../token_iterator").TokenIterator,f=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"],h=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"],g=f.concat(h),i={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},c=Object.keys(i);function l(t,n){return t.type.lastIndexOf(n+".xml")>-1}function s(t,n){for(var o=new x(t,n.row,n.column),u=o.getCurrentToken();u&&!l(u,"tag-name");)u=o.stepBackward();if(u)return u.value}function a(t,n){for(var o=new x(t,n.row,n.column),u=o.getCurrentToken();u&&!l(u,"attribute-name");)u=o.stepBackward();if(u)return u.value}var e=function(){};(function(){this.getCompletions=function(t,n,o,u){var d=n.getTokenAt(o.row,o.column);if(!d)return[];if(l(d,"tag-name")||l(d,"tag-open")||l(d,"end-tag-open"))return this.getTagCompletions(t,n,o,u);if(l(d,"tag-whitespace")||l(d,"attribute-name"))return this.getAttributeCompletions(t,n,o,u);if(l(d,"attribute-value"))return this.getAttributeValueCompletions(t,n,o,u);var b=n.getLine(o.row).substr(0,o.column);return/&[a-z]*$/i.test(b)?this.getHTMLEntityCompletions(t,n,o,u):[]},this.getTagCompletions=function(t,n,o,u){return c.map(function(d){return{value:d,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(t,n,o,u){var d=s(n,o);if(!d)return[];var b=g;return d in i&&(b=b.concat(Object.keys(i[d]))),b.map(function(w){return{caption:w,snippet:w+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(t,n,o,u){var d=s(n,o),b=a(n,o);if(!d)return[];var w=[];return d in i&&b in i[d]&&typeof i[d][b]=="object"&&(w=Object.keys(i[d][b])),w.map(function(k){return{caption:k,snippet:k,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(t,n,o,u){var d=["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"];return d.map(function(b){return{caption:b,snippet:b,meta:"html entity",score:1e6}})}}).call(e.prototype),m.HtmlCompletions=e}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),h=r("./text").Mode,g=r("./javascript").Mode,i=r("./css").Mode,c=r("./html_highlight_rules").HtmlHighlightRules,l=r("./behaviour/xml").XmlBehaviour,s=r("./folding/html").FoldMode,a=r("./html_completions").HtmlCompletions,e=r("../worker/worker_client").WorkerClient,t=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],n=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],o=function(u){this.fragmentContext=u&&u.fragmentContext,this.HighlightRules=c,this.$behaviour=new l,this.$completer=new a,this.createModeDelegates({"js-":g,"css-":i}),this.foldingRules=new s(this.voidElements,f.arrayToMap(n))};x.inherits(o,h),function(){this.blockComment={start:"<!--",end:"-->"},this.voidElements=f.arrayToMap(t),this.getNextLineIndent=function(u,d,b){return this.$getIndent(d)},this.checkOutdent=function(u,d,b){return!1},this.getCompletions=function(u,d,b,w){return this.$completer.getCompletions(u,d,b,w)},this.createWorker=function(u){if(this.constructor==o){var d=new e(["ace"],"ace/mode/html_worker","Worker");return d.attachToDocument(u.getDocument()),this.fragmentContext&&d.call("setOptions",[{context:this.fragmentContext}]),d.on("error",function(b){u.setAnnotations(b.data)}),d.on("terminate",function(){u.clearAnnotations()}),d}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(o.prototype),m.Mode=o}),ace.define("ace/mode/markdown_highlight_rules",["require","exports","module","ace/config","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/html_highlight_rules"],function(r,m,_){"use strict";var x=r("../config").$modes,f=r("../lib/oop"),h=r("../lib/lang"),g=r("./text_highlight_rules").TextHighlightRules,i=r("./html_highlight_rules").HtmlHighlightRules,c=function(s){return"(?:[^"+h.escapeRegExp(s)+"\\\\]|\\\\.)*"},l=function(){i.call(this);var s={token:"support.function",regex:/^\s*(```+[^`]*|~~~+[^~]*)$/,onMatch:function(e,t,n,o){var u=e.match(/^(\s*)([`~]+)(.*)/),d=/[\w-]+|$/.exec(u[3])[0];return x[d]||(d=""),n.unshift("githubblock",[],[u[1],u[2],d],t),this.token},next:"githubblock"},a=[{token:"support.function",regex:".*",onMatch:function(e,t,n,o){var u=n[1],d=n[2][0],b=n[2][1],w=n[2][2],k=/^(\s*)(`+|~+)\s*$/.exec(e);if(k&&k[1].length<d.length+3&&k[2].length>=b.length&&k[2][0]==b[0])return n.splice(0,3),this.next=n.shift(),this.token;if(this.next="",w&&x[w]){var R=x[w].getTokenizer().getLineTokens(e,u.slice(0));return n[1]=R.state,R.tokens}return this.token}}];this.$rules.start.unshift({token:"empty_line",regex:"^$",next:"allowBlock"},{token:"markup.heading.1",regex:"^=+(?=\\s*$)"},{token:"markup.heading.2",regex:"^\\-+(?=\\s*$)"},{token:function(e){return"markup.heading."+e.length},regex:/^#{1,6}(?=\s|$)/,next:"header"},s,{token:"string.blockquote",regex:"^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",next:"blockquote"},{token:"constant",regex:"^ {0,3}(?:(?:\\* ?){3,}|(?:\\- ?){3,}|(?:\\_ ?){3,})\\s*$",next:"allowBlock"},{token:"markup.list",regex:"^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",next:"listblock-start"},{include:"basic"}),this.addRules({basic:[{token:"constant.language.escape",regex:/\\[\\`*_{}\[\]()#+\-.!]/},{token:"support.function",regex:"(`+)(.*?[^`])(\\1)"},{token:["text","constant","text","url","string","text"],regex:'^([ ]{0,3}\\[)([^\\]]+)(\\]:\\s*)([^ ]+)(\\s*(?:["][^"]+["])?(\\s*))$'},{token:["text","string","text","constant","text"],regex:"(\\[)("+c("]")+")(\\]\\s*\\[)("+c("]")+")(\\])"},{token:["text","string","text","markup.underline","string","text"],regex:"(\\!?\\[)("+c("]")+')(\\]\\()((?:[^\\)\\s\\\\]|\\\\.|\\s(?=[^"]))*)(\\s*"'+c('"')+'"\\s*)?(\\))'},{token:"string.strong",regex:"([*]{2}|[_]{2}(?=\\S))(.*?\\S[*_]*)(\\1)"},{token:"string.emphasis",regex:"([*]|[_](?=\\S))(.*?\\S[*_]*)(\\1)"},{token:["text","url","text"],regex:`(<)((?:https?|ftp|dict):[^'">\\s]+|(?:mailto:)?[-.\\w]+\\@[-a-z0-9]+(?:\\.[-a-z0-9]+)*\\.[a-z]+)(>)`}],allowBlock:[{token:"support.function",regex:"^ {4}.+",next:"allowBlock"},{token:"empty_line",regex:"^$",next:"allowBlock"},{token:"empty",regex:"",next:"start"}],header:[{regex:"$",next:"start"},{include:"basic"},{defaultToken:"heading"}],"listblock-start":[{token:"support.variable",regex:/(?:\[[ x]\])?/,next:"listblock"}],listblock:[{token:"empty_line",regex:"^$",next:"start"},{token:"markup.list",regex:"^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",next:"listblock-start"},{include:"basic",noEscape:!0},s,{defaultToken:"list"}],blockquote:[{token:"empty_line",regex:"^\\s*$",next:"start"},{token:"string.blockquote",regex:"^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",next:"blockquote"},{include:"basic",noEscape:!0},{defaultToken:"string.blockquote"}],githubblock:a}),this.normalizeRules()};f.inherits(l,g),m.MarkdownHighlightRules=l}),ace.define("ace/mode/folding/markdown",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,h=r("../../range").Range,g=m.FoldMode=function(){};x.inherits(g,f),function(){this.foldingStartMarker=/^(?:[=-]+\s*$|#{1,6} |`{3})/,this.getFoldWidget=function(i,c,l){var s=i.getLine(l);return this.foldingStartMarker.test(s)?s[0]=="`"&&i.bgTokenizer.getState(l)=="start"?"end":"start":""},this.getFoldWidgetRange=function(i,c,l){var s=i.getLine(l),a=s.length,e=i.getLength(),t=l,n=l;if(!s.match(this.foldingStartMarker))return;if(s[0]=="`")if(i.bgTokenizer.getState(l)!=="start"){for(;++l<e&&(s=i.getLine(l),!(s[0]=="`"&s.substring(0,3)=="```")););return new h(t,a,l,0)}else{for(;l-- >0&&(s=i.getLine(l),!(s[0]=="`"&s.substring(0,3)=="```")););return new h(l,s.length,t,0)}var o;function u(v){return o=i.getTokens(v)[0],o&&o.type.lastIndexOf(d,0)===0}var d="markup.heading";function b(){var v=o.value[0];return v=="="?6:v=="-"?5:7-o.value.search(/[^#]|$/)}if(u(l)){for(var w=b();++l<e;)if(u(l)){var k=b();if(k>=w)break}if(n=l-(!o||["=","-"].indexOf(o.value[0])==-1?1:2),n>t)for(;n>t&&/^\s*$/.test(i.getLine(n));)n--;if(n>t){var R=i.getLine(n).length;return new h(t,a,n,R)}}}}.call(g.prototype)}),ace.define("ace/mode/sh_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,h=m.reservedKeywords="!|{|}|case|do|done|elif|else|esac|fi|for|if|in|then|until|while|&|;|export|local|read|typeset|unset|elif|select|set|function|declare|readonly",g=m.languageConstructs="[|]|alias|bg|bind|break|builtin|cd|command|compgen|complete|continue|dirs|disown|echo|enable|eval|exec|exit|fc|fg|getopts|hash|help|history|jobs|kill|let|logout|popd|printf|pushd|pwd|return|set|shift|shopt|source|suspend|test|times|trap|type|ulimit|umask|unalias|wait",i=function(){var c=this.createKeywordMapper({keyword:h,"support.function.builtin":g,"invalid.deprecated":"debugger"},"identifier"),l="(?:(?:[1-9]\\d*)|(?:0))",s="(?:\\.\\d+)",a="(?:\\d+)",e="(?:(?:"+a+"?"+s+")|(?:"+a+"\\.))",t="(?:(?:"+e+"|"+a+"))",n="(?:"+t+"|"+e+")",o="(?:&"+a+")",u="[a-zA-Z_][a-zA-Z0-9_]*",d="(?:"+u+"(?==))",b="(?:\\$(?:SHLVL|\\$|\\!|\\?))",w="(?:"+u+"\\s*\\(\\))";this.$rules={start:[{token:"constant",regex:/\\./},{token:["text","comment"],regex:/(^|\s)(#.*)$/},{token:"string.start",regex:'"',push:[{token:"constant.language.escape",regex:/\\(?:[$`"\\]|$)/},{include:"variables"},{token:"keyword.operator",regex:/`/},{token:"string.end",regex:'"',next:"pop"},{defaultToken:"string"}]},{token:"string",regex:"\\$'",push:[{token:"constant.language.escape",regex:/\\(?:[abeEfnrtv\\'"]|x[a-fA-F\d]{1,2}|u[a-fA-F\d]{4}([a-fA-F\d]{4})?|c.|\d{1,3})/},{token:"string",regex:"'",next:"pop"},{defaultToken:"string"}]},{regex:"<<<",token:"keyword.operator"},{stateName:"heredoc",regex:"(<<-?)(\\s*)(['\"`]?)([\\w\\-]+)(['\"`]?)",onMatch:function(k,R,v){var y=k[2]=="-"?"indentedHeredoc":"heredoc",p=k.split(this.splitRegex);return v.push(y,p[4]),[{type:"constant",value:p[1]},{type:"text",value:p[2]},{type:"string",value:p[3]},{type:"support.class",value:p[4]},{type:"string",value:p[5]}]},rules:{heredoc:[{onMatch:function(k,R,v){return k===v[1]?(v.shift(),v.shift(),this.next=v[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^	+"},{onMatch:function(k,R,v){return k===v[1]?(v.shift(),v.shift(),this.next=v[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(k,R){return R[0]==="heredoc"||R[0]==="indentedHeredoc"?R[0]:k}},{token:["keyword","text","text","text","variable"],regex:/(declare|local|readonly)(\s+)(?:(-[fixar]+)(\s+))?([a-zA-Z_][a-zA-Z0-9_]*\b)/},{token:"variable.language",regex:b},{token:"variable",regex:d},{include:"variables"},{token:"support.function",regex:w},{token:"support.function",regex:o},{token:"string",start:"'",end:"'"},{token:"constant.numeric",regex:n},{token:"constant.numeric",regex:l+"\\b"},{token:c,regex:"[a-zA-Z_][a-zA-Z0-9_]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\*\\*|\\/|\\/\\/|~|<|>|<=|=>|=|!=|[%&|`]"},{token:"punctuation.operator",regex:";"},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]]"},{token:"paren.rparen",regex:"[\\)\\}]",next:"pop"}],variables:[{token:"variable",regex:/(\$)(\w+)/},{token:["variable","paren.lparen"],regex:/(\$)(\()/,push:"start"},{token:["variable","paren.lparen","keyword.operator","variable","keyword.operator"],regex:/(\$)(\{)([#!]?)(\w+|[*@#?\-$!0_])(:[?+\-=]?|##?|%%?|,,?\/|\^\^?)?/,push:"start"},{token:"variable",regex:/\$[*@#?\-$!0_]/},{token:["variable","paren.lparen"],regex:/(\$)(\{)/,push:"start"}]},this.normalizeRules()};x.inherits(i,f),m.ShHighlightRules=i}),ace.define("ace/mode/sh",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sh_highlight_rules","ace/range","ace/mode/folding/cstyle","ace/mode/behaviour/cstyle"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./sh_highlight_rules").ShHighlightRules,g=r("../range").Range,i=r("./folding/cstyle").FoldMode,c=r("./behaviour/cstyle").CstyleBehaviour,l=function(){this.HighlightRules=h,this.foldingRules=new i,this.$behaviour=new c};x.inherits(l,f),function(){this.lineCommentStart="#",this.getNextLineIndent=function(a,e,t){var n=this.$getIndent(e),o=this.getTokenizer().getLineTokens(e,a),u=o.tokens;if(u.length&&u[u.length-1].type=="comment")return n;if(a=="start"){var d=e.match(/^.*[\{\(\[:]\s*$/);d&&(n+=t)}return n};var s={pass:1,return:1,raise:1,break:1,continue:1};this.checkOutdent=function(a,e,t){if(t!==`\r
`&&t!=="\r"&&t!==`
`)return!1;var n=this.getTokenizer().getLineTokens(e.trim(),a).tokens;if(!n)return!1;do var o=n.pop();while(o&&(o.type=="comment"||o.type=="text"&&o.value.match(/^\s+$/)));return o?o.type=="keyword"&&s[o.value]:!1},this.autoOutdent=function(a,e,t){t+=1;var n=this.$getIndent(e.getLine(t)),o=e.getTabString();n.slice(-o.length)==o&&e.remove(new g(t,n.length-o.length,t,n.length))},this.$id="ace/mode/sh",this.snippetFileId="ace/snippets/sh"}.call(l.prototype),m.Mode=l}),ace.define("ace/mode/markdown",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript","ace/mode/xml","ace/mode/html","ace/mode/markdown_highlight_rules","ace/mode/folding/markdown","ace/mode/javascript","ace/mode/html","ace/mode/sh","ace/mode/sh","ace/mode/xml","ace/mode/css"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./javascript").Mode,g=r("./xml").Mode,i=r("./html").Mode,c=r("./markdown_highlight_rules").MarkdownHighlightRules,l=r("./folding/markdown").FoldMode,s=function(){this.HighlightRules=c,this.createModeDelegates({javascript:r("./javascript").Mode,html:r("./html").Mode,bash:r("./sh").Mode,sh:r("./sh").Mode,xml:r("./xml").Mode,css:r("./css").Mode}),this.foldingRules=new l,this.$behaviour=this.$defaultBehaviour};x.inherits(s,f),function(){this.type="text",this.blockComment={start:"<!--",end:"-->"},this.$quotes={'"':'"',"`":"`"},this.getNextLineIndent=function(a,e,t){if(a=="listblock"){var n=/^(\s*)(?:([-+*])|(\d+)\.)(\s+)/.exec(e);if(!n)return"";var o=n[2];return o||(o=parseInt(n[3],10)+1+"."),n[1]+o+n[4]}else return this.$getIndent(e)},this.$id="ace/mode/markdown",this.snippetFileId="ace/snippets/markdown"}.call(s.prototype),m.Mode=s}),ace.define("ace/mode/coffee_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules;x.inherits(h,f);function h(){var g="[$A-Za-z_\\x7f-\\uffff][$\\w\\x7f-\\uffff]*",i="this|throw|then|try|typeof|super|switch|return|break|by|continue|catch|class|in|instanceof|is|isnt|if|else|extends|for|own|finally|function|while|when|new|no|not|delete|debugger|do|loop|of|off|or|on|unless|until|and|yes|yield|export|import|default",c="true|false|null|undefined|NaN|Infinity",l="case|const|function|var|void|with|enum|implements|interface|let|package|private|protected|public|static",s="Array|Boolean|Date|Function|Number|Object|RegExp|ReferenceError|String|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray",a="Math|JSON|isNaN|isFinite|parseInt|parseFloat|encodeURI|encodeURIComponent|decodeURI|decodeURIComponent|String|",e="window|arguments|prototype|document",t=this.createKeywordMapper({keyword:i,"constant.language":c,"invalid.illegal":l,"language.support.class":s,"language.support.function":a,"variable.language":e},"identifier"),n={token:["paren.lparen","variable.parameter","paren.rparen","text","storage.type"],regex:/(?:(\()((?:"[^")]*?"|'[^')]*?'|\/[^\/)]*?\/|[^()"'\/])*?)(\))(\s*))?([\-=]>)/.source},o=/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]?|37[0-7]?|[4-7][0-7]?|.)/;this.$rules={start:[{token:"constant.numeric",regex:"(?:0x[\\da-fA-F]+|(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:[eE][+-]?\\d+)?)"},{stateName:"qdoc",token:"string",regex:"'''",next:[{token:"string",regex:"'''",next:"start"},{token:"constant.language.escape",regex:o},{defaultToken:"string"}]},{stateName:"qqdoc",token:"string",regex:'"""',next:[{token:"string",regex:'"""',next:"start"},{token:"paren.string",regex:"#{",push:"start"},{token:"constant.language.escape",regex:o},{defaultToken:"string"}]},{stateName:"qstring",token:"string",regex:"'",next:[{token:"string",regex:"'",next:"start"},{token:"constant.language.escape",regex:o},{defaultToken:"string"}]},{stateName:"qqstring",token:"string.start",regex:'"',next:[{token:"string.end",regex:'"',next:"start"},{token:"paren.string",regex:"#{",push:"start"},{token:"constant.language.escape",regex:o},{defaultToken:"string"}]},{stateName:"js",token:"string",regex:"`",next:[{token:"string",regex:"`",next:"start"},{token:"constant.language.escape",regex:o},{defaultToken:"string"}]},{regex:"[{}]",onMatch:function(u,d,b){return this.next="",u=="{"&&b.length?(b.unshift("start",d),"paren"):u=="}"&&b.length&&(b.shift(),this.next=b.shift()||"",this.next.indexOf("string")!=-1)?"paren.string":"paren"}},{token:"string.regex",regex:"///",next:"heregex"},{token:"string.regex",regex:/(?:\/(?![\s=])[^[\/\n\\]*(?:(?:\\[\s\S]|\[[^\]\n\\]*(?:\\[\s\S][^\]\n\\]*)*])[^[\/\n\\]*)*\/)(?:[imgy]{0,4})(?!\w)/},{token:"comment",regex:"###(?!#)",next:"comment"},{token:"comment",regex:"#.*"},{token:["punctuation.operator","text","identifier"],regex:"(\\.)(\\s*)("+l+")"},{token:"punctuation.operator",regex:"\\.{1,3}"},{token:["keyword","text","language.support.class","text","keyword","text","language.support.class"],regex:"(class)(\\s+)("+g+")(?:(\\s+)(extends)(\\s+)("+g+"))?"},{token:["entity.name.function","text","keyword.operator","text"].concat(n.token),regex:"("+g+")(\\s*)([=:])(\\s*)"+n.regex},n,{token:"variable",regex:"@(?:"+g+")?"},{token:t,regex:g},{token:"punctuation.operator",regex:"\\,|\\."},{token:"storage.type",regex:"[\\-=]>"},{token:"keyword.operator",regex:"(?:[-+*/%<>&|^!?=]=|>>>=?|\\-\\-|\\+\\+|::|&&=|\\|\\|=|<<=|>>=|\\?\\.|\\.{2,3}|[!*+-=><])"},{token:"paren.lparen",regex:"[({[]"},{token:"paren.rparen",regex:"[\\]})]"},{token:"text",regex:"\\s+"}],heregex:[{token:"string.regex",regex:".*?///[imgy]{0,4}",next:"start"},{token:"comment.regex",regex:"\\s+(?:#.*)?"},{token:"string.regex",regex:"\\S+"}],comment:[{token:"comment",regex:"###",next:"start"},{defaultToken:"comment"}]},this.normalizeRules()}m.CoffeeHighlightRules=h}),ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,h=r("../../range").Range,g=m.FoldMode=function(){};x.inherits(g,f),function(){this.getFoldWidgetRange=function(i,c,l){var s=this.indentationBlock(i,l);if(s)return s;var a=/\S/,e=i.getLine(l),t=e.search(a);if(!(t==-1||e[t]!="#")){for(var n=e.length,o=i.getLength(),u=l,d=l;++l<o;){e=i.getLine(l);var b=e.search(a);if(b!=-1){if(e[b]!="#")break;d=l}}if(d>u){var w=i.getLine(d).length;return new h(u,n,d,w)}}},this.getFoldWidget=function(i,c,l){var s=i.getLine(l),a=s.search(/\S/),e=i.getLine(l+1),t=i.getLine(l-1),n=t.search(/\S/),o=e.search(/\S/);if(a==-1)return i.foldWidgets[l-1]=n!=-1&&n<o?"start":"","";if(n==-1){if(a==o&&s[a]=="#"&&e[a]=="#")return i.foldWidgets[l-1]="",i.foldWidgets[l+1]="","start"}else if(n==a&&s[a]=="#"&&t[a]=="#"&&i.getLine(l-2).search(/\S/)==-1)return i.foldWidgets[l-1]="start",i.foldWidgets[l+1]="","";return n!=-1&&n<a?i.foldWidgets[l-1]="start":i.foldWidgets[l-1]="",a<o?"start":""}}.call(g.prototype)}),ace.define("ace/mode/coffee",["require","exports","module","ace/mode/coffee_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/coffee","ace/range","ace/mode/text","ace/worker/worker_client","ace/lib/oop"],function(r,m,_){"use strict";var x=r("./coffee_highlight_rules").CoffeeHighlightRules,f=r("./matching_brace_outdent").MatchingBraceOutdent,h=r("./folding/coffee").FoldMode,g=r("../range").Range,i=r("./text").Mode,c=r("../worker/worker_client").WorkerClient,l=r("../lib/oop");function s(){this.HighlightRules=x,this.$outdent=new f,this.foldingRules=new h}l.inherits(s,i),function(){var a=/(?:[({[=:]|[-=]>|\b(?:else|try|(?:swi|ca)tch(?:\s+[$A-Za-z_\x7f-\uffff][$\w\x7f-\uffff]*)?|finally))\s*$|^\s*(else\b\s*)?(?:if|for|while|loop)\b(?!.*\bthen\b)/;this.lineCommentStart="#",this.blockComment={start:"###",end:"###"},this.getNextLineIndent=function(e,t,n){var o=this.$getIndent(t),u=this.getTokenizer().getLineTokens(t,e).tokens;return!(u.length&&u[u.length-1].type==="comment")&&e==="start"&&a.test(t)&&(o+=n),o},this.checkOutdent=function(e,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(e,t,n){this.$outdent.autoOutdent(t,n)},this.createWorker=function(e){var t=new c(["ace"],"ace/mode/coffee_worker","Worker");return t.attachToDocument(e.getDocument()),t.on("annotate",function(n){e.setAnnotations(n.data)}),t.on("terminate",function(){e.clearAnnotations()}),t},this.$id="ace/mode/coffee",this.snippetFileId="ace/snippets/coffee"}.call(s.prototype),m.Mode=s}),ace.define("ace/mode/scss_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),h=r("./text_highlight_rules").TextHighlightRules,g=r("./css_highlight_rules"),i=function(){var c=f.arrayToMap(g.supportType.split("|")),l=f.arrayToMap("hsl|hsla|rgb|rgba|url|attr|counter|counters|abs|adjust_color|adjust_hue|alpha|join|blue|ceil|change_color|comparable|complement|darken|desaturate|floor|grayscale|green|hue|if|invert|join|length|lighten|lightness|mix|nth|opacify|opacity|percentage|quote|red|round|saturate|saturation|scale_color|transparentize|type_of|unit|unitless|unquote".split("|")),s=f.arrayToMap(g.supportConstant.split("|")),a=f.arrayToMap(g.supportConstantColor.split("|")),e=f.arrayToMap("@mixin|@extend|@include|@import|@media|@debug|@warn|@if|@for|@each|@while|@else|@font-face|@-webkit-keyframes|if|and|!default|module|def|end|declare".split("|")),t=f.arrayToMap("a|abbr|acronym|address|applet|area|article|aside|audio|b|base|basefont|bdo|big|blockquote|body|br|button|canvas|caption|center|cite|code|col|colgroup|command|datalist|dd|del|details|dfn|dir|div|dl|dt|em|embed|fieldset|figcaption|figure|font|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|i|iframe|img|input|ins|keygen|kbd|label|legend|li|link|map|mark|menu|meta|meter|nav|noframes|noscript|object|ol|optgroup|option|output|p|param|pre|progress|q|rp|rt|ruby|s|samp|script|section|select|small|source|span|strike|strong|style|sub|summary|sup|table|tbody|td|textarea|tfoot|th|thead|time|title|tr|tt|u|ul|var|video|wbr|xmp".split("|")),n="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";this.$rules={start:[{token:"comment",regex:"\\/\\/.*$"},{token:"comment",regex:"\\/\\*",next:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:'["].*\\\\$',next:"qqstring"},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"string",regex:"['].*\\\\$",next:"qstring"},{token:"constant.numeric",regex:n+"(?:ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:"constant.numeric",regex:n},{token:["support.function","string","support.function"],regex:"(url\\()(.*)(\\))"},{token:function(o){return c.hasOwnProperty(o.toLowerCase())?"support.type":e.hasOwnProperty(o)?"keyword":s.hasOwnProperty(o)?"constant.language":l.hasOwnProperty(o)?"support.function":a.hasOwnProperty(o.toLowerCase())?"support.constant.color":t.hasOwnProperty(o.toLowerCase())?"variable.language":"text"},regex:"\\-?[@a-z_][@a-z0-9_\\-]*"},{token:"variable",regex:"[a-z_\\-$][a-z0-9_\\-$]*\\b"},{token:"variable.language",regex:"#[a-z0-9-_]+"},{token:"variable.language",regex:"\\.[a-z0-9-_]+"},{token:"variable.language",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"},{token:"keyword.operator",regex:"<|>|<=|>=|==|!=|-|%|#|\\+|\\$|\\+|\\*"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"},{caseInsensitive:!0}],comment:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}],qqstring:[{token:"string",regex:'(?:(?:\\\\.)|(?:[^"\\\\]))*?"',next:"start"},{token:"string",regex:".+"}],qstring:[{token:"string",regex:"(?:(?:\\\\.)|(?:[^'\\\\]))*?'",next:"start"},{token:"string",regex:".+"}]}};x.inherits(i,h),m.ScssHighlightRules=i}),ace.define("ace/mode/scss",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/scss_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/css","ace/mode/folding/cstyle","ace/mode/css_completions"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./scss_highlight_rules").ScssHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,i=r("./behaviour/css").CssBehaviour,c=r("./folding/cstyle").FoldMode,l=r("./css_completions").CssCompletions,s=function(){this.HighlightRules=h,this.$outdent=new g,this.$behaviour=new i,this.$completer=new l,this.foldingRules=new c};x.inherits(s,f),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(a,e,t){var n=this.$getIndent(e),o=this.getTokenizer().getLineTokens(e,a).tokens;if(o.length&&o[o.length-1].type=="comment")return n;var u=e.match(/^.*\{\s*$/);return u&&(n+=t),n},this.checkOutdent=function(a,e,t){return this.$outdent.checkOutdent(e,t)},this.autoOutdent=function(a,e,t){this.$outdent.autoOutdent(e,t)},this.getCompletions=function(a,e,t,n){return this.$completer.getCompletions(a,e,t,n)},this.$id="ace/mode/scss"}.call(s.prototype),m.Mode=s}),ace.define("ace/mode/sass_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/scss_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),h=r("./scss_highlight_rules").ScssHighlightRules,g=function(){h.call(this);var i=this.$rules.start;i[1].token=="comment"&&(i.splice(1,1,{onMatch:function(c,l,s){return s.unshift(this.next,-1,c.length-2,l),"comment"},regex:/^\s*\/\*/,next:"comment"},{token:"error.invalid",regex:"/\\*|[{;}]"},{token:"support.type",regex:/^\s*:[\w\-]+\s/}),this.$rules.comment=[{regex:/^\s*/,onMatch:function(c,l,s){return s[1]===-1&&(s[1]=Math.max(s[2],c.length-1)),c.length<=s[1]?(s.shift(),s.shift(),s.shift(),this.next=s.shift(),"text"):(this.next="","comment")},next:"start"},{defaultToken:"comment"}])};x.inherits(g,h),m.SassHighlightRules=g}),ace.define("ace/mode/sass",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sass_highlight_rules","ace/mode/folding/coffee"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./sass_highlight_rules").SassHighlightRules,g=r("./folding/coffee").FoldMode,i=function(){this.HighlightRules=h,this.foldingRules=new g,this.$behaviour=this.$defaultBehaviour};x.inherits(i,f),function(){this.lineCommentStart="//",this.$id="ace/mode/sass"}.call(i.prototype),m.Mode=i}),ace.define("ace/mode/less_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,h=r("./css_highlight_rules"),g=function(){var i="@import|@media|@font-face|@keyframes|@-webkit-keyframes|@supports|@charset|@plugin|@namespace|@document|@page|@viewport|@-ms-viewport|or|and|when|not",c=i.split("|"),l=h.supportType.split("|"),s=this.createKeywordMapper({"support.constant":h.supportConstant,keyword:i,"support.constant.color":h.supportConstantColor,"support.constant.fonts":h.supportConstantFonts},"identifier",!0),a="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";this.$rules={start:[{token:"comment",regex:"\\/\\/.*$"},{token:"comment",regex:"\\/\\*",next:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:["constant.numeric","keyword"],regex:"("+a+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:"constant.numeric",regex:a},{token:["support.function","paren.lparen","string","paren.rparen"],regex:"(url)(\\()(.*)(\\))"},{token:["support.function","paren.lparen"],regex:"(:extend|[a-z0-9_\\-]+)(\\()"},{token:function(e){return c.indexOf(e.toLowerCase())>-1?"keyword":"variable"},regex:"[@\\$][a-z0-9_\\-@\\$]*\\b"},{token:"variable",regex:"[@\\$]\\{[a-z0-9_\\-@\\$]*\\}"},{token:function(e,t){return l.indexOf(e.toLowerCase())>-1?["support.type.property","text"]:["support.type.unknownProperty","text"]},regex:"([a-z0-9-_]+)(\\s*:)"},{token:"keyword",regex:"&"},{token:s,regex:"\\-?[@a-z_][@a-z0-9_\\-]*"},{token:"variable.language",regex:"#[a-z0-9-_]+"},{token:"variable.language",regex:"\\.[a-z0-9-_]+"},{token:"variable.language",regex:":[a-z_][a-z0-9-_]*"},{token:"constant",regex:"[a-z0-9-_]+"},{token:"keyword.operator",regex:"<|>|<=|>=|=|!=|-|%|\\+|\\*"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"},{caseInsensitive:!0}],comment:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]},this.normalizeRules()};x.inherits(g,f),m.LessHighlightRules=g}),ace.define("ace/mode/less",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/less_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/css","ace/mode/css_completions","ace/mode/folding/cstyle"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./less_highlight_rules").LessHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,i=r("./behaviour/css").CssBehaviour,c=r("./css_completions").CssCompletions,l=r("./folding/cstyle").FoldMode,s=function(){this.HighlightRules=h,this.$outdent=new g,this.$behaviour=new i,this.$completer=new c,this.foldingRules=new l};x.inherits(s,f),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(a,e,t){var n=this.$getIndent(e),o=this.getTokenizer().getLineTokens(e,a).tokens;if(o.length&&o[o.length-1].type=="comment")return n;var u=e.match(/^.*\{\s*$/);return u&&(n+=t),n},this.checkOutdent=function(a,e,t){return this.$outdent.checkOutdent(e,t)},this.autoOutdent=function(a,e,t){this.$outdent.autoOutdent(e,t)},this.getCompletions=function(a,e,t,n){return this.$completer.getCompletions("ruleset",e,t,n)},this.$id="ace/mode/less"}.call(s.prototype),m.Mode=s}),ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,h=m.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};m.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},m.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},m.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var g=m.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"},i=m.constantNumericBinary={token:"constant.numeric",regex:/\b(0[bB][01](?:[01]|_(?=[01]))*)\b/},c=m.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/},l=m.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/},s=m.constantNumericRational={token:"constant.numeric",regex:/\b([\d]+(?:[./][\d]+)?ri?)\b/},a=m.constantNumericComplex={token:"constant.numeric",regex:/\b([\d]i)\b/},e=m.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"},t=m.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},n=function(){var o="abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|validates_inclusion_of|validates_numericality_of|validates_with|validates_each|authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|cache|expire_fragment|expire_cache_for|observe|cache_sweeper|has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|private_class_method|remove_method|undef_method",u="alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend",d="true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION",b="$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|$!|root_url|flash|session|cookies|params|request|response|logger|self",w=this.$keywords=this.createKeywordMapper({keyword:u,"constant.language":d,"variable.language":b,"support.function":o,"invalid.deprecated":"debugger"},"identifier"),k=`\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})`,R={"(":")","[":"]","{":"}","<":">","^":"^","|":"|","%":"%"};this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment.multiline",regex:"^=begin(?=$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:/[/](?=.*\/)/,next:"regex"},[{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(")/,push:[{token:"constant.language.escape",regex:k},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:k},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(')/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/%[qwx]([(\[<{^|%])/,onMatch:function(v,y,p){p.length&&(p=[]);var M=v[v.length-1];return p.unshift(M,y),this.next="qStateWithoutInterpolation",this.token}},{token:"string.start",regex:/%[QWX]?([(\[<{^|%])/,onMatch:function(v,y,p){p.length&&(p=[]);var M=v[v.length-1];return p.unshift(M,y),this.next="qStateWithInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[si]([(\[<{^|%])/,onMatch:function(v,y,p){p.length&&(p=[]);var M=v[v.length-1];return p.unshift(M,y),this.next="sStateWithoutInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[SI]([(\[<{^|%])/,onMatch:function(v,y,p){p.length&&(p=[]);var M=v[v.length-1];return p.unshift(M,y),this.next="sStateWithInterpolation",this.token}},{token:"string.regexp",regex:/%[r]([(\[<{^|%])/,onMatch:function(v,y,p){p.length&&(p=[]);var M=v[v.length-1];return p.unshift(M,y),this.next="rState",this.token}}],{token:"punctuation",regex:"::"},t,{token:"variable.global",regex:"[$][a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]*"},{token:["punctuation.operator","support.function"],regex:/(\.)([a-zA-Z_\d]+)(?=\()/},{token:["punctuation.operator","identifier"],regex:/(\.)([a-zA-Z_][a-zA-Z_\d]*)/},{token:"string.character",regex:"\\B\\?(?:"+k+"|\\S)"},{token:"punctuation.operator",regex:/\?(?=.+:)/},s,a,h,g,e,i,c,l,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:w,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(v,y,p){var M=v[2]=="-"||v[2]=="~"?"indentedHeredoc":"heredoc",C=v.split(this.splitRegex);return p.push(M,C[3]),[{type:"constant",value:C[1]},{type:"string",value:C[2]},{type:"support.class",value:C[3]},{type:"string",value:C[4]}]},regex:"(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(v,y,p){return v===p[1]?(p.shift(),p.shift(),this.next=p[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(v,y,p){return v===p[1]?(p.shift(),p.shift(),this.next=p[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(v,y){return y[0]==="heredoc"||y[0]==="indentedHeredoc"?y[0]:v}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]",onMatch:function(v,y,p){return this.next="",v=="}"&&p.length>1&&p[1]!="start"&&(p.shift(),this.next=p.shift()),this.token}},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:/[?:,;.]/}],comment:[{token:"comment.multiline",regex:"^=end(?=$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}],qStateWithInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(v,y,p){return p.length&&v===p[0]?(p.unshift(v,y),this.token):"string"}},{token:"constant.language.escape",regex:k},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(v,y,p){return p.length&&v===R[p[0]]?(p.shift(),this.next=p.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],qStateWithoutInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(v,y,p){return p.length&&v===p[0]?(p.unshift(v,y),this.token):"string"}},{token:"constant.language.escape",regex:/\\['\\]/},{token:"constant.language.escape",regex:/\\./},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(v,y,p){return p.length&&v===R[p[0]]?(p.shift(),this.next=p.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],sStateWithoutInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(v,y,p){return p.length&&v===p[0]?(p.unshift(v,y),this.token):"constant.other.symbol.ruby"}},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(v,y,p){return p.length&&v===R[p[0]]?(p.shift(),this.next=p.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],sStateWithInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(v,y,p){return p.length&&v===p[0]?(p.unshift(v,y),this.token):"constant.other.symbol.ruby"}},{token:"constant.language.escape",regex:k},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(v,y,p){return p.length&&v===R[p[0]]?(p.shift(),this.next=p.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],rState:[{token:"string.regexp",regex:/[(\[<{]/,onMatch:function(v,y,p){return p.length&&v===p[0]?(p.unshift(v,y),this.token):"constant.language.escape"}},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.regexp",regex:/\//},{token:"string.regexp",regex:/[)\]>}^|%][imxouesn]*/,onMatch:function(v,y,p){return p.length&&v[0]===R[p[0]]?(p.shift(),this.next=p.shift(),this.token):(this.next="","constant.language.escape")}},{include:"regex"},{defaultToken:"string.regexp"}],regex:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"constant.language.escape",regex:/\\[AGbBzZ]/},{token:"constant.language.escape",regex:/\\g<[a-zA-Z0-9]*>/},{token:["constant.language.escape","regexp.keyword","constant.language.escape"],regex:/(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/},{token:["constant.language.escape","invalid","constant.language.escape"],regex:/(\\p{\^?)([^/]*)(})/},{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:/[/][imxouesn]*/,next:"start"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"regexp.keyword",regex:/\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/},{token:"constant.language.escape",regex:/\[\^?/,push:"regex_character_class"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:/&?&?\[\^?/,push:"regex_character_class"},{token:"constant.language.escape",regex:"]",next:"pop"},{token:"constant.language.escape",regex:"-"},{defaultToken:"string.regexp.characterclass"}]},this.normalizeRules()};x.inherits(n,f),m.RubyHighlightRules=n}),ace.define("ace/mode/folding/ruby",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"],function(r,m,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,h=r("../../range").Range,g=r("../../token_iterator").TokenIterator,i=m.FoldMode=function(){};x.inherits(i,f),function(){this.indentKeywords={class:1,def:1,module:1,do:1,unless:1,if:1,while:1,for:1,until:1,begin:1,else:0,elsif:0,rescue:0,ensure:0,when:0,end:-1,case:1,"=begin":1,"=end":-1},this.foldingStartMarker=/(?:\s|^)(def|do|while|class|unless|module|if|for|until|begin|else|elsif|case|rescue|ensure|when)\b|({\s*$)|(=begin)/,this.foldingStopMarker=/(=end(?=$|\s.*$))|(^\s*})|\b(end)\b/,this.getFoldWidget=function(c,l,s){var a=c.getLine(s),e=this.foldingStartMarker.test(a),t=this.foldingStopMarker.test(a);if(e&&!t){var n=a.match(this.foldingStartMarker);if(n[1]){if((n[1]=="if"||n[1]=="else"||n[1]=="while"||n[1]=="until"||n[1]=="unless")&&(n[1]=="else"&&/^\s*else\s*$/.test(a)===!1||/^\s*(?:if|else|while|until|unless)\s*/.test(a)===!1)||n[1]=="when"&&/\sthen\s/.test(a)===!0)return;if(c.getTokenAt(s,n.index+2).type==="keyword")return"start"}else if(n[3]){if(c.getTokenAt(s,n.index+1).type==="comment.multiline")return"start"}else return"start"}if(l!="markbeginend"||!t||e&&t)return"";var n=a.match(this.foldingStopMarker);if(n[3]==="end"){if(c.getTokenAt(s,n.index+1).type==="keyword")return"end"}else if(n[1]){if(c.getTokenAt(s,n.index+1).type==="comment.multiline")return"end"}else return"end"},this.getFoldWidgetRange=function(c,l,s){var a=c.doc.getLine(s),e=this.foldingStartMarker.exec(a);if(e)return e[1]||e[3]?this.rubyBlock(c,s,e.index+2):this.openingBracketBlock(c,"{",s,e.index);var e=this.foldingStopMarker.exec(a);if(e)return e[3]==="end"&&c.getTokenAt(s,e.index+1).type==="keyword"?this.rubyBlock(c,s,e.index+1):e[1]==="=end"&&c.getTokenAt(s,e.index+1).type==="comment.multiline"?this.rubyBlock(c,s,e.index+1):this.closingBracketBlock(c,"}",s,e.index+e[0].length)},this.rubyBlock=function(c,C,s,a){var e=new g(c,C,s),t=e.getCurrentToken();if(!(!t||t.type!="keyword"&&t.type!="comment.multiline")){var n=t.value,o=c.getLine(C);switch(t.value){case"if":case"unless":case"while":case"until":var u=new RegExp("^\\s*"+t.value);if(!u.test(o))return;var d=this.indentKeywords[n];break;case"when":if(/\sthen\s/.test(o))return;case"elsif":case"rescue":case"ensure":var d=1;break;case"else":var u=new RegExp("^\\s*"+t.value+"\\s*$");if(!u.test(o))return;var d=1;break;default:var d=this.indentKeywords[n];break}var b=[n];if(d){var w=d===-1?c.getLine(C-1).length:c.getLine(C).length,k=C,R=[];if(R.push(e.getCurrentTokenRange()),e.step=d===-1?e.stepBackward:e.stepForward,t.type=="comment.multiline"){for(;t=e.step();)if(t.type==="comment.multiline"){if(d==1){if(w=6,t.value=="=end")break}else if(t.value=="=begin")break}}else for(;t=e.step();){var v=!1;if(t.type==="keyword"){var y=d*this.indentKeywords[t.value];switch(o=c.getLine(e.getCurrentTokenRow()),t.value){case"do":for(var p=e.$tokenIndex-1;p>=0;p--){var M=e.$rowTokens[p];if(M&&(M.value=="while"||M.value=="until"||M.value=="for")){y=0;break}}break;case"else":var u=new RegExp("^\\s*"+t.value+"\\s*$");(!u.test(o)||n=="case")&&(y=0,v=!0);break;case"if":case"unless":case"while":case"until":var u=new RegExp("^\\s*"+t.value);u.test(o)||(y=0,v=!0);break;case"when":(/\sthen\s/.test(o)||n=="case")&&(y=0,v=!0);break}if(y>0)b.unshift(t.value);else if(y<=0&&v===!1){if(b.shift(),!b.length&&((n=="while"||n=="until"||n=="for")&&t.value!="do"||t.value=="do"&&d==-1&&y!=0||t.value!="do"))break;y===0&&b.unshift(t.value)}}}if(!t)return null;if(a)return R.push(e.getCurrentTokenRange()),R;var C=e.getCurrentTokenRow();if(d===-1){if(t.type==="comment.multiline")var T=6;else var T=c.getLine(C).length;return new h(C,T,k-1,w)}else return new h(k,w,C-1,c.getLine(C-1).length)}}}}.call(i.prototype)}),ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/ruby"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./ruby_highlight_rules").RubyHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,i=r("../range").Range,c=r("./behaviour/cstyle").CstyleBehaviour,l=r("./folding/ruby").FoldMode,s=function(){this.HighlightRules=h,this.$outdent=new g,this.$behaviour=new c,this.foldingRules=new l,this.indentKeywords=this.foldingRules.indentKeywords};x.inherits(s,f),function(){this.lineCommentStart="#",this.getNextLineIndent=function(a,e,t){var n=this.$getIndent(e),o=this.getTokenizer().getLineTokens(e,a),u=o.tokens;if(u.length&&u[u.length-1].type=="comment")return n;if(a=="start"){var d=e.match(/^.*[\{\(\[]\s*$/),b=e.match(/^\s*(class|def|module)\s.*$/),w=e.match(/.*do(\s*|\s+\|.*\|\s*)$/),k=e.match(/^\s*(if|else|when|elsif|unless|while|for|begin|rescue|ensure)\s*/);(d||b||w||k)&&(n+=t)}return n},this.checkOutdent=function(a,e,t){return/^\s+(end|else|rescue|ensure)$/.test(e+t)||this.$outdent.checkOutdent(e,t)},this.autoOutdent=function(a,e,t){var n=e.getLine(t);if(/}/.test(n))return this.$outdent.autoOutdent(e,t);var o=this.$getIndent(n),u=e.getLine(t-1),d=this.$getIndent(u),b=e.getTabString();d.length<=o.length&&o.slice(-b.length)==b&&e.remove(new i(t,o.length-b.length,t,o.length))},this.getMatching=function(a,e,t){if(e==null){var n=a.selection.lead;t=n.column,e=n.row}var o=a.getTokenAt(e,t);if(o&&o.value in this.indentKeywords)return this.foldingRules.rubyBlock(a,e,t,!0)},this.$id="ace/mode/ruby",this.snippetFileId="ace/snippets/ruby"}.call(s.prototype),m.Mode=s}),ace.define("ace/mode/slim",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/slim_highlight_rules","ace/mode/javascript","ace/mode/markdown","ace/mode/coffee","ace/mode/scss","ace/mode/sass","ace/mode/less","ace/mode/ruby","ace/mode/css"],function(r,m,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,h=r("./slim_highlight_rules").SlimHighlightRules,g=function(){f.call(this),this.HighlightRules=h,this.createModeDelegates({javascript:r("./javascript").Mode,markdown:r("./markdown").Mode,coffee:r("./coffee").Mode,scss:r("./scss").Mode,sass:r("./sass").Mode,less:r("./less").Mode,ruby:r("./ruby").Mode,css:r("./css").Mode})};x.inherits(g,f),function(){this.$id="ace/mode/slim"}.call(g.prototype),m.Mode=g}),function(){ace.require(["ace/mode/slim"],function(r){typeof module=="object"&&typeof exports=="object"&&module&&(module.exports=r)})}();
