const SquirroGPT={fonts:["https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined","https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,900;1,100;1,300;1,400&display=swap"],styles:t=>`
            .hide {
                display: none !important;
            }

            #chat-circle {
                position: fixed;
                bottom: 24px;
                ${t.appearance.chatPosition}: 24px;
                background: ${t.appearance.chatIconColor||"#EC6A2B"};
                width: 10px;
                height: 10px;
                border-radius: 50%;
                color: white;
                padding: 23px;
                cursor: pointer;
                overflow: hidden;
                z-index: 9999999;
                box-shadow: 0px 3px 5px -1px rgba(0, 0, 0, 0.20), 0px 6px 10px 0px rgba(0, 0, 0, 0.14), 0px 1px 18px 0px rgba(0, 0, 0, 0.12);
            }

            #chat-circle img {
                display: none;
                height: 83px;
                top: -33px;
                position: relative;
                left: -30px;
                user-drag: none;
                user-select: none;
                -moz-user-select: none;
                -webkit-user-drag: none;
                -webkit-user-select: none;
                -ms-user-select: none;
            }

            #chat-circle i {
                margin-left: -6px;
                margin-top: -6px;
            }

            #chat-overlay {
                background: rgba(255, 255, 255, 0.1);
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                border-radius: 50%;
                display: none;
            }

            .chat-box {
                visibility: hidden;
                background: #efefef;
                position: fixed;
                ${t.appearance.chatPosition}: 30px;
                bottom: 100px;
                width: 350px;
                height: 535px;
                max-width: 85vw;
                max-height: 100vh;
                border-radius: 5px;
                box-shadow: 0px 3px 5px -1px rgba(0, 0, 0, 0.20), 0px 6px 10px 0px rgba(0, 0, 0, 0.14), 0px 1px 18px 0px rgba(0, 0, 0, 0.12);
            }

            .chat-box .chat-box-actions {
                display: flex;
                flex-direction: row;
                gap: 8px;
                align-items: center;
            }

            .chat-box-toggle {
                cursor: pointer;
            }

            .chat-box-header {
                background: white;
                height: 32px;
                padding: 8px;
                padding-left: 16px;
                border-top-left-radius: 5px;
                border-top-right-radius: 5px;
                font-size: 14px;
                font-weight: 500;
                display: flex;
                align-items: center;
                font-family: Roboto;
            }

            .chat-box-header .chat-box-header-wrapper {
                display: flex;
                flex-direction: row;
                justify-content: space-between;
                width: 100%;
                gap: 8px;
                align-items: center;
            }

            .chat-box-header .chat-box-header-title {
                text-overflow: ellipsis;
                overflow: hidden;
                white-space: nowrap;
            }

            .chat-box-header .chat-box-toggle {
                line-height: 0;
            }

            .chat-box-body {
                position: relative;
                overflow: hidden;
                height: calc(100% - 47px);
                border-bottom-left-radius: 5px;
                border-bottom-right-radius: 5px;
            }

            .chat-box-body:after {
                content: "";
                opacity: 0.1;
                top: 0;
                left: 0;
                bottom: 0;
                right: 0;
                height: 100%;
                position: absolute;
                z-index: -1;
            }

            .chat-logs {
                padding: 0;
                height: 100%;
            }

            .chat-box.expanded {
                width: 90vw;
                max-width: 880px;
                height: 90vh;
                max-height: 1080px;
                position: relative;
                right: auto;
                left: auto;
                bottom: auto;
                box-shadow: none;
            }

            .chat-box-wrapper {
                position: fixed;
                z-index: 9999999;
                top: 0;
            }

            .chat-box-wrapper.expanded {
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100%;
                height: 100%;
                visibility: hidden;
            }

            .chat-box-wrapper.expanded::before {
                content: ' ';
                position: absolute;
                background: rgba(0,0,0,0.5);
                width: 100%;
                height: 100%;
                visibility: visible;
                left: -8px;
            }

            .chat-box-wrapper:not(.chat-open)::before {
                display: none !important;
            }

            .chat-box-wrapper.expanded i.expand {
                display: none !important;
            }

            .chat-box-wrapper.expanded i.contract {
                display: block;
            }

            .chat-box-wrapper i.contract {
                display: none;
            }

            .chat-box iframe {
                width: 100%;
                height: 100%;
            }

            .chat-box .new-chat-button {
                color: #0677B5;
                padding: 5px 10px;
                border-radius: 8px;
                border: 1px solid #0677B5;
                background: transparent;
                display: flex;
                align-items: center;
                cursor: pointer;
                font-size: 13px;
                width: max-content;
            }

            .chat-box .new-chat-button:hover {
                background-color: rgba(25, 118, 210, 0.04);
                border: 1px solid #1976d2;
            }

            .chat-box .new-chat-button i {
                margin-right: 8px;
            }

            .material-icons {
                font-family: "Material Icons";
                font-family: "Material Symbols Outlined";
                font-weight: normal;
                font-style: normal;
                font-size: 24px;
                line-height: 1;
                letter-spacing: normal;
                text-transform: none;
                display: inline-block;
                white-space: nowrap;
                word-wrap: normal;
                direction: ltr;
                -webkit-font-feature-settings: "liga";
                -webkit-font-smoothing: antialiased;
            }

            #squirro-gpt-chat.item-detail-open .chat-box iframe {
                width: 100%;
                height: 100%;
                position: fixed;
                top: 0;
                max-width: 100%;
                max-height: 100%;
                left: 0;
            }
        `,template:t=>{const e=t?.behaviour?.enableSupportButton&&t?.behaviour?.supportEmail?.length>0,a=t?.behaviour?.supportEmail,n=e?`<a href="mailto:${a}" style="color: black; text-decoration: none; display: flex; align-items: center;">
                    <i class="material-icons" style="font-size: 20px; cursor: pointer;">support_agent</i>
                </a>`:"";return`
            <div id="squirro-gpt-chat">
                <div id="chat-circle" class="btn btn-raised chat-circle">
                    <div id="chat-overlay"></div>
                    <i class="material-icons">${t?.appearance?.icon||"assistant"}</i>
                </div>
                <div class="chat-box-wrapper">
                    <div class="chat-box">
                        <div class="chat-box-header">
                            <div class="chat-box-header-wrapper">
                                <p class="chat-box-header-title">
                                    ${t?.appearance?.chatTitle||"Squirro Chat"}
                                </p>
                                <div class="chat-box-actions">
                                    <button class="new-chat-button">
                                        <i class="material-icons" style="font-size: 20px; cursor: pointer;">quick_phrases</i>
                                        New Chat
                                    </button>
                                    ${n}
                                    <i class="material-icons expand" style="font-size: 20px; cursor: pointer;">open_in_full</i>
                                    <i class="material-icons contract" style="font-size: 20px; cursor: pointer;">close_fullscreen</i>
                                    <span class="chat-box-toggle">
                                        <i class="material-icons">close</i>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="chat-box-body">
                            <div class="chat-box-overlay"></div>
                            <div class="chat-logs">
                                <iframe id="squirro-dashboard" src="$$INSTANCE_URL$$app/dashboard/$$PROJECT_ID$$/$$DASHBOARD_ID$$?token=$$TOKEN$$&assistant=true" style="border:none;" allow="clipboard-read; clipboard-write"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `},loadFonts:function(){this.fonts.forEach(t=>{let e=document.createElement("link");e.href=t,e.rel="stylesheet",document.body.appendChild(e)})},load:function({projectId:t,dashboardId:e,token:a,squirroInstanceUrl:n,preferences:i,customButton:s=!1}){if(!t||!e||!a||!n)throw new Error("SquirroGPT: The options projectId, dashboardId, token and squirroInstanceUrl are mandatory.");this.loadFonts();const b=document.getElementById("squirro-gpt-shadow-root").attachShadow({mode:"open"}),d=document.createElement("div");d.style.height="100%";const u=this.template(i).replace("$$PROJECT_ID$$",t).replace("$$DASHBOARD_ID$$",e).replace("$$TOKEN$$",a).replace("$$INSTANCE_URL$$",n);d.innerHTML=u+`<style>${this.styles(i)}</style>`,b.appendChild(d);const o=document.getElementById("squirro-gpt-shadow-root").shadowRoot.firstChild,p=o.querySelectorAll("#chat-circle")[0],c=o.querySelectorAll(".chat-box")[0],g=o.querySelectorAll(".chat-box-toggle")[0],r=o.querySelectorAll(".chat-box-wrapper")[0],h=o.querySelectorAll("i.expand")[0],x=o.querySelectorAll("i.contract")[0],m=o.querySelectorAll("button.new-chat-button")[0];p.addEventListener("click",()=>{const l=r.classList.contains("chat-open");c.style.visibility=l?"hidden":"visible",r.classList.toggle("chat-open")}),g.addEventListener("click",()=>{c.style.visibility="hidden",r.classList.remove("chat-open")}),h.addEventListener("click",()=>{c.classList.add("expanded"),r.classList.add("expanded")}),x.addEventListener("click",()=>{c.classList.remove("expanded"),r.classList.remove("expanded")}),m.addEventListener("click",()=>{o.querySelectorAll("iframe#squirro-dashboard")[0].contentWindow.postMessage({startNewChat:!0},"*")}),window.addEventListener("message",({data:l})=>{const f=o.querySelectorAll("#squirro-gpt-chat")[0];l.isItemDetailOpen!=null&&f.classList.toggle("item-detail-open",!!l.isItemDetailOpen)});const w=i?.appearance?.large&&!i?.appearance?.small;(s||w)&&(h.classList.add("hide"),x.classList.add("hide"),c.classList.add("expanded"),r.classList.add("expanded"),s&&p.classList.add("hide"))},init:async function(t){const e=`${t.squirroInstanceUrl}studio/genai_proxy/projects/${t.projectId}/chat-preferences?token=${t.token}`,n=await(await fetch(e)).json()||{},i=document.createElement("div");i.id="squirro-gpt-shadow-root";const s={...t,preferences:n};document.body.appendChild(i),document.readyState!=="loading"?this.load(s):document.addEventListener("DOMContentLoaded",this.load.bind(this,s))},open:function(){const t=document.getElementById("squirro-gpt-shadow-root").shadowRoot.firstChild,e=t.querySelectorAll(".chat-box")[0],a=t.querySelectorAll(".chat-box-wrapper")[0];e.style.visibility="visible",a.classList.add("chat-open")}};window.SquirroGPT?.q?.[0]&&SquirroGPT.init(window.SquirroGPT.q[0]?.[0]),window.SquirroGPT=SquirroGPT;
