import logging
from unittest.mock import patch

from octopus.utils import set_log_verbosity

LOG_FORMAT = "%(asctime)s %(filename)s %(name)s %(levelname)-7s %(message)s"


@patch("octopus.utils.logger.logging.basicConfig")
def test_set_log_verbosity(mock_log_basic_config) -> None:
    """Test set_log_verbosity."""
    set_log_verbosity(logging.ERROR)
    mock_log_basic_config.assert_called_once_with(
        level=logging.ERROR,
        format=LOG_FORMAT,
        datefmt="%Y-%m-%d %H:%M:%S",
        force=True,
    )
    mock_log_basic_config.reset_mock()

    set_log_verbosity(logging.WARNING)
    mock_log_basic_config.assert_called_once_with(
        level=logging.WARNING,
        format=LOG_FORMAT,
        datefmt="%Y-%m-%d %H:%M:%S",
        force=True,
    )
    mock_log_basic_config.reset_mock()

    set_log_verbosity(logging.INFO)
    mock_log_basic_config.assert_called_once_with(
        level=logging.INFO,
        format=LOG_FORMAT,
        datefmt="%Y-%m-%d %H:%M:%S",
        force=True,
    )
    mock_log_basic_config.reset_mock()

    set_log_verbosity(logging.DEBUG)
    mock_log_basic_config.assert_called_once_with(
        level=logging.DEBUG,
        format=LOG_FORMAT,
        datefmt="%Y-%m-%d %H:%M:%S",
        force=True,
    )
    mock_log_basic_config.reset_mock()
