import json

import pytest
from cryptography.fernet import Fernet

from octopus.utils import decrypt, encrypt, load_key, load_vault


def test_encrypt_decrypt():
    key = Fernet.generate_key().decode()
    value = "test"
    encrypted = encrypt(value, key)
    assert value == decrypt(encrypted, key)


def test_load_key(tmp_path):
    key = Fernet.generate_key().decode()
    key_file = tmp_path / "key"
    key_file.write_text(key)

    assert key == load_key(key_file)


def test_load_key_nonexistent_file(tmp_path):
    key_file = tmp_path / "key"

    with pytest.raises(FileNotFoundError, match=f"File `{key_file}` does not exist."):
        load_key(key_file)


def test_load_vault(tmp_path):
    vault = {
        "key1": {"key": "value1"},
        "key2": {"key": "value2"},
    }
    vault_file = tmp_path / "vault"
    vault_file.write_text(json.dumps(vault))

    assert vault == load_vault(vault_file)


def test_load_vault_nonexistent_file(tmp_path):
    vault_file = tmp_path / "vault"

    with pytest.raises(FileNotFoundError, match=f"File `{vault_file}` does not exist."):
        load_vault(vault_file)
