from octopus.text import Autocomplete


def test_autocomplete():
    autocomplete = Autocomplete("Test")
    autocomplete.insert("apple")
    autocomplete.insert("banana")
    autocomplete.insert("orange")
    autocomplete.insert("grape")

    # Test autocomplete with prefix ""
    results = autocomplete("")
    assert sorted(results) == ["apple", "banana", "grape", "orange"]

    # Test autocomplete with prefix "a"
    results = autocomplete("a")
    assert results == {"apple"}

    # Test autocomplete with prefix "b"
    results = autocomplete("b")
    assert results == {"banana"}

    # Test autocomplete with prefix "n"
    results = autocomplete("n")
    assert sorted(results) == sorted(["banana", "orange"])

    # Test autocomplete with prefix "o"
    results = autocomplete("o")
    assert results == {"orange"}

    # Test autocomplete with prefix "g"
    results = autocomplete("g")
    assert results == {"grape"}

    # Test autocomplete with prefix "ap"
    results = autocomplete("ap")
    assert results == {"apple"}

    # Test autocomplete with prefix "ba"
    results = autocomplete("ba")
    assert results == {"banana"}

    # Test autocomplete with prefix "or"
    results = autocomplete("or")
    assert results == {"orange"}

    # Test autocomplete with prefix "gr"
    results = autocomplete("gr")
    assert results == {"grape"}

    # Test autocomplete with prefix "c" (no matching words)
    results = autocomplete("c")
    assert results == set()

    # Test autocomplete with prefix "apz" (no matching words)
    results = autocomplete("apz")
    assert results == set()

    # Test autocomplete with prefix "a" after cache eviction
    autocomplete.insert("apricot")
    results = autocomplete("a")
    assert results == {"apple", "apricot"}

    # Test autocomplete with prefix "a" after cache eviction and reinsertion
    autocomplete.insert("avocado")
    results = autocomplete("a")
    assert results == {"apple", "apricot", "avocado"}


def test_autocomplete_real_names():
    autocomplete = Autocomplete("Test 2")
    for name in NAMES:
        autocomplete.insert(name)

    # Test autocomplete with prefix "m"
    assert sorted(autocomplete("m")) == sorted(
        [
            "Michael Johnson",
            "Jessica Miller",
            "Nicholas Moore",
            "Elizabeth Martinez",
            "Megan Thomas",
            "Matthew Walker",
        ]
    )

    # Test autocomplete with prefix "mi"
    assert sorted(autocomplete("mi")) == sorted(
        [
            "Michael Johnson",
            "Jessica Miller",
        ]
    )

    # Test autocomplete with prefix "Mi"
    assert sorted(autocomplete("Mi")) == sorted(
        [
            "Michael Johnson",
            "Jessica Miller",
        ]
    )

    # Test autocomplete with prefix ""
    assert sorted(autocomplete("")) == sorted(NAMES)


def test_save_load_index(tmpdir):
    path = tmpdir.join("autocomplete.json")
    autocomplete = Autocomplete("Test")
    autocomplete.insert("apple")
    autocomplete.save_index(path)
    loaded = Autocomplete.load_index(path)
    assert loaded._items == {"apple"}


NAMES = [
    "Michael Johnson",
    "Jessica Miller",
    "Emily Roberts",
    "David Smith",
    "Christopher Brown",
    "Amanda Davis",
    "Joshua Wilson",
    "Sarah Taylor",
    "Nicholas Moore",
    "Elizabeth Martinez",
    "Andrew Anderson",
    "Megan Thomas",
    "Brandon Jackson",
    "Laura White",
    "Kevin Harris",
    "Olivia Clark",
    "Daniel Rodriguez",
    "Rachel Lewis",
    "Matthew Walker",
    "Ashley Lee",
    "Brian Hall",
    "Jennifer Allen",
    "Aaron Young",
    "Stephanie Hernandez",
    "Adam King",
    "Nicole Wright",
    "Justin Scott",
    "Heather Lopez",
    "Ryan Adams",
    "Brittany Baker",
]
