from io import BytesIO

import pytest

from octopus.pdf import check_password_protected_pdf


@pytest.fixture(
    params=[
        ("tests/octopus/pdf/test-data/password_protected.pdf", True),
        ("tests/octopus/pdf/test-data/password_protected_permissions.pdf", False),
    ]
)
def password_protected_cases(request):
    return request.param


def test_password_protected(password_protected_cases):
    path, expected = password_protected_cases
    with open(path, "rb") as f:
        fs = BytesIO(f.read())

    assert expected == check_password_protected_pdf(fs)
