import pytest

from octopus.data.company_data import define_display_labels


def test_no_values(item_no_labels):
    define_display_labels(item_no_labels, [])
    assert "company_name" not in item_no_labels["keywords"]
    assert "document_date" not in item_no_labels["keywords"]
    assert "document_type" not in item_no_labels["keywords"]


def test_pred_values(item_pred_labels):
    define_display_labels(item_pred_labels, [])

    assert item_pred_labels["keywords"].get("company_name") == ["Company C"]
    assert item_pred_labels["keywords"].get("document_type") == ["ANNUAL REPORT"]
    assert item_pred_labels["keywords"].get("document_date") == ["12/12/2012"]


def test_true_values(item_true_labels, company_data):
    define_display_labels(item_true_labels, company_data)

    assert item_true_labels["keywords"].get("company_uid") == [
        "SG_11111",
        "SG_22222",
    ]
    assert item_true_labels["keywords"].get("company_name") == [
        "Company B",
        "Company A",
    ]
    assert item_true_labels["keywords"].get("company_name_true") == [
        "Company B",
        "Company A",
    ]
    assert item_true_labels["keywords"].get("document_type") == ["CP"]
    assert item_true_labels["keywords"].get("document_date") == ["11/11/2011"]


@pytest.fixture
def company_data():
    return [
        {
            "company_uid": ["SG_11111"],
            "company_name": ["Company B"],
            "company_cif": ["11111"],
        },
        {
            "company_uid": ["SG_22222"],
            "company_name": ["Company A"],
            "company_cif": ["22222"],
        },
    ]


@pytest.fixture
def item_no_labels():
    return {
        "id": "test-item-1",
        "title": "Test Item",
        "created_at": "2021-10-25T09:20:30",
        "body": "Test Body",
        "keywords": {},
    }


@pytest.fixture
def item_pred_labels():
    return {
        "id": "test-item-1",
        "title": "Test Item",
        "created_at": "2021-10-25T09:20:30",
        "body": "Test Body",
        "keywords": {
            "company_name_pred": ["Company C"],
            "document_type_pred": ["ANNUAL REPORT"],
            "document_date_pred": ["12/12/2012"],
        },
    }


@pytest.fixture
def item_true_labels():
    return {
        "id": "test-item-1",
        "title": "Test Item",
        "created_at": "2021-10-25T09:20:30",
        "body": "Test Body",
        "keywords": {
            "company_uid": ["SG_11111", "SG_22222"],
            "document_type_true": ["CP"],
            "document_type_pred": ["ANNUAL REPORT"],
            "document_date_true": ["11/11/2011"],
            "document_date_pred": ["12/12/2012"],
        },
    }
