import pytest

from octopus.classification import doc_type_pred


def test_sub_items_unknown():
    item = _mock_sub_item("unknown", "FACILITY AGREEMENT")
    doc_type_pred(item, item["sub_items"][0]["body"])

    assert "FACILITY AGREEMENT" == item["keywords"]["document_type_pred"][0]


def test_sub_items(test_cases_pages):
    item, expected = test_cases_pages
    doc_type_pred(item, item["sub_items"][0]["body"])

    assert expected == item["keywords"]["document_type_pred"][0]


def test_predict_zip_unknown():
    item = _mock_zip_ref("unknown")
    item["keywords"]["document_type_pred_ml"] = ["ML"]
    doc_type_pred(item, item["keywords"]["zip_reference"])

    assert item["keywords"]["document_type_pred"][0] == "ML"


def test_predict_zip(test_cases_zip):
    item, expected = test_cases_zip
    doc_type_pred(item, item["keywords"]["zip_reference"])

    assert expected == item["keywords"]["document_type_pred"][0]


def _mock_sub_item(txt, doc_type):
    return {
        "id": "mock_sub_item",
        "title": "mock_sub_item",
        "keywords": {
            "document_type_pred_ml": [doc_type],
        },
        "sub_items": [{"body": txt}],
    }


def _mock_zip_ref(zip_ref):
    return {
        "id": "mock_zip_ref",
        "title": "mock_zip_ref",
        "keywords": {
            "zip_reference": [zip_ref],
        },
    }


@pytest.fixture(
    params=[
        (_mock_zip_ref("credit memo"), "CM"),
        (_mock_zip_ref("credit memorandum"), "CM"),
        (_mock_zip_ref("credit proposal"), "CP"),
        (_mock_zip_ref("credit proposition"), "CP"),
        (_mock_zip_ref("credit review"), "CR"),
        (_mock_zip_ref("memo"), "Unclassified"),
        (_mock_zip_ref("memorandum"), "Unclassified"),
        (_mock_zip_ref("proposal"), "Unclassified"),
        (_mock_zip_ref("proposition"), "Unclassified"),
        (_mock_zip_ref("review"), "Unclassified"),
    ]
)
def test_cases_zip(request):
    return request.param


@pytest.fixture(
    params=[
        (
            _mock_sub_item("Compliance checklist form 5", "Unknown"),
            "INTERNAL DOCUMENTS (BBCA)",
        ),
        (
            _mock_sub_item("ComplianCe cheCklist foRm 5", "Unknown"),
            "INTERNAL DOCUMENTS (BBCA)",
        ),
        (
            _mock_sub_item("Compliance bla bla checklist form 5", "Unknown"),
            "Unknown",
        ),
        (
            _mock_sub_item("Credit review checklist", "Unknown"),
            "INTERNAL DOCUMENTS (BBCA)",
        ),
        (
            _mock_sub_item("Credit rEvIew cHecKList", "Unknown"),
            "INTERNAL DOCUMENTS (BBCA)",
        ),
        (
            _mock_sub_item("Credit review bla bla checklist", "Unknown"),
            "Unknown",
        ),
    ]
)
def test_cases_pages(request):
    return request.param
