"""Query related utilities."""


def build_query_string(labels: "dict[str, list[str]]", *additional_queries: str) -> str:
    """Create a squirro query using the labels.

    Use "OR" to combine values
    within the same label and "AND" for different labels. Include any
    additional queries joined by "AND".

    Args:
        labels: Labels to query by.
        additional_queries: Additional queries appended to the final query.

    Returns:
        Squirro query string.
    """
    return " AND ".join(
        [
            "(" + " OR ".join([f"{label}:{value}" for value in values]) + ")"
            for label, values in labels.items()
        ]
        + list(additional_queries)
    )
