"""Logger utilities."""

import logging
import pprint
from io import StringIO
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from typing import Any


def set_log_verbosity(verbosity: int) -> None:
    """Set log verbosity.

    Args:
        verbosity: log verbosity level
    """
    logging.basicConfig(
        level=verbosity,
        format="%(asctime)s %(filename)s %(name)s %(levelname)-7s %(message)s",
        datefmt="%Y-%m-%d %H:%M:%S",
        force=True,
    )


def prettier_dict(data: "dict[str, Any]") -> str:
    """Pretty print a dictionary.

    Args:
        data: The dictionary to pretty print

    Returns:
        The pretty printed item
    """
    msg = StringIO()
    pp = pprint.PrettyPrinter(2, stream=msg)
    pp.pprint(data)
    val = f"\n{msg.getvalue()}"
    msg.close()
    return val
