"""Generic utilities."""

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from typing import Any


def remove_dict_nested_empty_values(data: "dict[str, Any]") -> "dict[str, Any]":
    """Remove empty values from a dictionary recursively.

    Args:
        data: The dictionary to remove empty values from.

    Returns:
        The dictionary with empty values removed.
    """
    keys_to_remove = []
    for k, v in data.items():
        if isinstance(v, dict):
            remove_dict_nested_empty_values(v)
            if not v:
                keys_to_remove.append(k)
        elif isinstance(v, list):
            if not v:
                keys_to_remove.append(k)
            else:
                v[:] = [
                    item
                    for item in v
                    if not (
                        isinstance(item, dict)
                        and not remove_dict_nested_empty_values(item)
                    )
                ]
        elif not v:
            keys_to_remove.append(k)

    for k in keys_to_remove:
        data.pop(k)

    return data
