"""Configuration utilities."""

import logging
from pathlib import Path
from typing import TYPE_CHECKING

from squirro.common.config import create_config_parser

if TYPE_CHECKING:
    from configparser import ConfigParser


def load_config(
    path: str = "/opt/squirro/octopus/config/main.ini",
) -> "ConfigParser":
    """Load configuration from file.

    Args:
        path: Path to configuration file. Defaults to
            "/opt/squirro/octopus/config/main.ini".

    Returns:
        ConfigParser instance.

    Raises:
        FileNotFoundError: If the file does not exist.
    """
    fp = Path(path)
    if not fp.exists():
        msg = f"File {fp} not found."
        logging.error(msg)
        raise FileNotFoundError(msg)
    config: ConfigParser = create_config_parser()
    config.read(fp)
    return config
