"""Upload related utilities."""

from datetime import datetime
from typing import TYPE_CHECKING

import pytz

if TYPE_CHECKING:
    from octopus.activity_tracking import RejectionReason


def generate_failed_file_payload(
    title: str, reason: "RejectionReason"
) -> "dict[str, str | RejectionReason]":
    """Generate a failed file payload.

    Args:
        title: The title of the file.
        reason: The rejection reason.

    Returns:
        A dictionary representing the failed file payload.
    """
    created_at = (
        datetime.now()
        .astimezone(pytz.timezone("Asia/Singapore"))
        .strftime("%d/%m/%Y %H:%M:%S")
    )
    return {
        "source_type": "User Upload",
        "title": title,
        "created_at": created_at,
        "ingestion_status": "Failed",
        "rejection_reason": reason,
    }
