"""Email related utilities."""

import json
from typing import TYPE_CHECKING

from octopus.clients import init_redis_client

from .structs import EmailConfig

if TYPE_CHECKING:
    from typing import Any


def load_email_config() -> "EmailConfig":
    """Load the email configuration.

    Returns:
        The email configuration.
    """
    redis_client = init_redis_client()
    distribution_list: dict[str, Any] = {}
    triggers: dict[str, Any] = {}
    if data := redis_client.hget("email_notifications", "distribution_list"):
        distribution_list = json.loads(data.decode())
    if data := redis_client.hget("email_notifications", "triggers"):
        triggers = json.loads(data.decode())
    return EmailConfig(
        distribution_list=distribution_list,
        triggers=triggers,
    )
