"""User utils."""

import json
import logging
from typing import TYPE_CHECKING

from octopus.clients import init_redis_client

if TYPE_CHECKING:
    from typing import Any


def get_users_info(emails: "list[str] | None" = None) -> "list[dict[str, Any]]":
    """Get user info from redis.

    Args:
        emails: List of emails to filter.

    Returns:
        List of user info.
    """
    redis_client = init_redis_client()

    try:
        user_roles_mapping = {
            k.decode(): v.decode()
            for k, v in redis_client.hgetall("user_roles_hash").items()
        }
    except Exception:
        logging.exception("Failed to get users from redis.")
        raise

    return [
        json.loads(v)
        for k, v in user_roles_mapping.items()
        if not emails or k in emails
    ]
