"""Report columns."""

from dataclasses import dataclass
from typing import Literal


@dataclass
class ReportColumn:
    """A column in the report."""

    name: str
    source: Literal["ES", "DB"]
    is_keyword: bool | None = None
    squirro_field: str | None = None
    is_datetime: bool | None = None
    datetime_format: str | None = None


REPORT_COLUMNS = [
    ReportColumn(
        name="Item ID",
        source="ES",
        is_keyword=False,
        squirro_field="id",
        is_datetime=False,
    ),
    ReportColumn(
        name="Segment",
        source="ES",
        is_keyword=True,
        squirro_field="wfi_company_segment",
        is_datetime=False,
    ),
    ReportColumn(
        name="Unique Identifier",
        source="ES",
        is_keyword=True,
        squirro_field="company_uid",
        is_datetime=False,
    ),
    ReportColumn(
        name="RM Name",
        source="ES",
        is_keyword=True,
        squirro_field="rm_name",
        is_datetime=False,
    ),
    ReportColumn(
        name="RM Code",
        source="ES",
        is_keyword=True,
        squirro_field="wfi_company_rm_code",
        is_datetime=False,
    ),
    ReportColumn(
        name="RM Team Name",
        source="ES",
        is_keyword=True,
        squirro_field="wfi_company_team_name",
        is_datetime=False,
    ),
    ReportColumn(
        name="BBCA CSO Name",
        source="ES",
        is_keyword=True,
        squirro_field="cso_name",
        is_datetime=False,
    ),
    ReportColumn(
        name="Document Name",
        source="ES",
        is_keyword=False,
        squirro_field="title",
        is_datetime=False,
    ),
    ReportColumn(
        name="Upload Date & Time",
        source="ES",
        is_keyword=False,
        squirro_field="created_at",
        is_datetime=True,
        datetime_format="%d/%m/%Y %H:%M:%S",
    ),
    ReportColumn(
        name="Uploaded By",
        source="ES",
        is_keyword=True,
        squirro_field="user_name",
        is_datetime=False,
    ),
    ReportColumn(
        name="No. of Pages",
        source="ES",
        is_keyword=True,
        squirro_field="num_pages",
        is_datetime=False,
    ),
    ReportColumn(
        name="Document Type",
        source="ES",
        is_keyword=True,
        squirro_field="document_type",
        is_datetime=False,
    ),
    ReportColumn(
        name="Customer Name",
        source="ES",
        is_keyword=True,
        squirro_field="company_name",
        is_datetime=False,
    ),
    ReportColumn(
        name="Company CIF",
        source="ES",
        is_keyword=True,
        squirro_field="company_cif",
        is_datetime=False,
    ),
    ReportColumn(
        name="Document Date",
        source="ES",
        is_keyword=True,
        squirro_field="document_date",
        is_datetime=True,
        datetime_format="%d/%m/%Y",
    ),
    ReportColumn(
        name="ES Status Code",
        source="ES",
        is_keyword=True,
        squirro_field="current_doc_status",
        is_datetime=False,
    ),
    ReportColumn(
        name="Ageing Days",
        source="ES",
        is_keyword=False,
        squirro_field="N/A",  # to be calculated at runtime
        is_datetime=False,
    ),
    ReportColumn(
        name="Latest Status Code",
        source="DB",
        is_datetime=False,
    ),
    ReportColumn(
        name="Latest Status Header",
        source="DB",
        is_datetime=False,
    ),
    ReportColumn(
        name="Creator of Latest Status",
        source="DB",
        is_datetime=False,
    ),
    ReportColumn(
        name="Date of Latest Status",
        source="DB",
        is_datetime=True,
        datetime_format="%d/%m/%Y %H:%M:%S",
    ),
]
