"""Company name suffixes."""

import re

SUFFIXES: "tuple[tuple[str,...], ...]" = (
    ("Aksjeselskap", "A. S.", "A.S."),
    ("Aktiebolag", "A. B.", "A.B."),
    ("Aktiengesellschaft", "A. G.", "A.G."),
    ("Besloten vennootschap", "B. V.", "B.V."),
    ("Limited Liability Company", "L. L. C.", "L.L.C.", "LLC"),
    ("Limited Liability Partnership", "L. L. P.", "L.L.P.", "LLP"),
    ("Private Limited", "Pte. Ltd.", "Pte.Ltd.", "Pte Ltd"),
    ("Limited Partnership", "L. P.", "L.P."),
    ("Limited", "Ltd"),
    ("Cooperative", "Co-Op"),
    ("Incorporation",),
    ("Corporation", "Corp."),
    (
        "Gesellschaft mit beschrankter Haftung",
        "Gesellschaft mit beschrnkter Haftung",
        "GmbH",
    ),
    ("Incorporated", "Inc."),
    ("Kommanditgesellschaft auf Aktien", "K. Ga. A.", "K.Ga.A.", "KGaA"),
    ("Company", "Co."),
    ("Naamloze Vennootschap", "N. V.", "N.V."),
    ("Osakeyhtio", "Osakeyhti ", "Osakeyhti", "Oy."),
    ("Proprietary", "Pty."),
    ("Sendirian Berhad", "Sdn. Bhd.", "Sdn.Bhd.", "Sdn Bhd"),
    ("Berhad", "Bhd"),
    ("Societe Anonyme", "Socit Anonyme", "Socit  Anonyme", "S. A.", "S.A."),
    ("Societas Europaea", "S. E.", "S.E."),
)


def generate_suffix_list() -> "list[list[str]]":
    """Generate list of company name suffixes.

    Returns:
        List of company name suffixes.
    """
    suffix_list = []
    for suffixes in SUFFIXES:
        suffix_regex = []
        for suffix in suffixes:
            name = re.sub(r"\s+", " ", suffix.lower())
            if (name := name.strip()) not in suffix_regex:
                suffix_regex.append(" " + name.replace(".", r"\."))
        suffix_list.append(suffix_regex)
    return suffix_list
