"""Define display labels."""

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from collections.abc import Hashable
    from typing import Any


DISPLAY_LABELS = ["company_name", "document_type", "document_date"]


def define_display_labels(
    item: "dict[str, Any]",
    company_data: "list[dict[Hashable, list[str]]]",
) -> None:
    """Define the display labels for the pipelet.

    Args:
        item: The item to consume
        company_data: The company data
    """
    # Assign company_name_true if company uid is provided by user
    if company_data:
        company_name_true: list[str] = [
            company["company_name"][0] for company in company_data
        ]
        item["keywords"]["company_name_true"] = company_name_true

    for label in DISPLAY_LABELS:
        label_true = f"{label}_true"
        label_pred = f"{label}_pred"

        # The default value for label_pred is added in the respective
        # classification pipelet so label_pred always has a value
        display_value = item.get("keywords", {}).get(
            label_true, item.get("keywords", {}).get(label_pred)
        )

        if not display_value:
            continue

        item["keywords"][label] = display_value
