"""Squirro client."""

from typing import TYPE_CHECKING

from octopus.utils import load_config
from squirro_client import SquirroClient

if TYPE_CHECKING:
    from configparser import ConfigParser


def init_squirro_client(
    cfg: "ConfigParser | None" = None,
    project: "str" = "squirro",
) -> "tuple[SquirroClient, str]":
    """Initialize squirro client.

    Args:
        cfg: ConfigParser instance.
        project: Project section to read.

    Returns:
        Authenticated Squirro client, project id.
    """
    if not cfg:
        cfg = load_config()
    client = SquirroClient(
        None,
        None,
        cluster=cfg["squirro"]["cluster"],
    )
    client.authenticate(refresh_token=cfg["squirro"]["token"])
    return client, cfg[project].get("project_id")
