"""Elasticsearch client."""

from elasticsearch import Elasticsearch

from octopus.utils import load_config


def init_es_client() -> Elasticsearch:
    """Initialize an Elasticsearch client.

    Returns:
        Elasticsearch client
    """
    cfg = load_config()
    es_cfg = load_config("/etc/squirro/common.ini")["index"]

    return Elasticsearch(
        es_cfg["es_index_servers"].split(","),
        ca_certs=es_cfg["es_pem_path"],
        http_auth=(es_cfg["es_auth_user"], es_cfg["es_auth_password"]),
        verify_certs=cfg["squirro"]["environment"] not in {"SIT", "UAT"},
    )
