"""Rejection reasons for documents that are rejected or failed to ingest."""

from enum import StrEnum

REJECTED = (
    "We regret to inform you that your file has been rejected. However, if "
    "you still wish to proceed with storing your file within Squirro, "
)
INFORM_ADMIN = f"{REJECTED} we kindly request you to inform the admin."
REUPLOAD = f"{REJECTED} we kindly request you to upload it again."
TO_BE_RETRIED = (
    "As a result, another attempt will be made to store the file in WFI. "
    "No further actions are required."
)


class RejectionReason(StrEnum):
    """Reasons for documents that are rejected or failed to ingest."""

    # 20012
    CREATED_OVER_24H = f"The document was created more than 24 hours ago. {REUPLOAD}"
    # 20003
    ITEM_HAS_NO_FILE = (
        f"The document does not have any files. {REJECTED} we kindly request "
        "you to attach files to the document and upload it again."
    )
    # 20000
    FILE_NOT_FOUND = f"The file was not found. {REUPLOAD}"
    # 20004
    FILE_NOT_SUPPORTED = (
        f"The file type is not supported. {REJECTED} we kindly request you to "
        "change file's type and upload it again."
    )
    # 20001
    FILE_TOO_LARGE = (
        f"The file exceeds maximum size. {REJECTED} we kindly request you to "
        "resize and upload it again."
    )
    INTERNAL_ERRORS = (
        f"The server is facing some internal issues. {REJECTED} we kindly "
        "request you to upload it again."
    )
    INVALID_FILE = (
        f"The file seems to be invalid. {REJECTED} we kindly request you to "
        "upload again.",
    )
    # 20002
    PASSWORD_PROTECTED = (
        f"The file is password protected. {REJECTED} we kindly request you to "
        "remove password protection and upload it again."
    )
    # 20005
    SENDER_NOT_WHITELISTED = (
        f"The sender's email is not whitelisted. {REJECTED} we  kindly "
        "request you to change sender's email and upload it again."
    )
    # 10003
    WFI_FILENET_NOT_FOUND = (
        "FileNet environment was unavailable when storing into WFI. " f"{TO_BE_RETRIED}"
    )
    # 10002
    WFI_INVALID_REQUEST = (
        f"Invalid request was used when storing into WFI. {INFORM_ADMIN}"
    )
    # 20006
    WFI_LABEL_NOT_SUPPORTED = (
        f"The label value type is not supported in WFI. {INFORM_ADMIN}"
    )
    # 20007
    WFI_LABEL_TOO_LONG = f"The label value exceeds maximum size in WFI. {INFORM_ADMIN}"
    # 20010
    WFI_RETRY_CREATED_TIME_NOT_FOUND = (
        "The creation timestamp for the document was not found in Redis hash. "
        f"{INFORM_ADMIN}"
    )
    # 20008
    WFI_CHECKIN_FAILED = f"The request to store into WFI failed. {TO_BE_RETRIED}"
