"""Documentations."""

import logging
from typing import TYPE_CHECKING

from flask import send_from_directory

from squirro.sdk.studio import StudioPlugin

if TYPE_CHECKING:
    from flask import Response


log = logging.getLogger(__name__)

plugin = StudioPlugin(__name__, static_folder="site/")
if not plugin.static_folder:
    raise RuntimeError


static_folder = plugin.static_folder


@plugin.route("/<project_id>", allow_project_readers=True)  # type: ignore[misc]
@plugin.route("/<project_id>/<path:path>", allow_project_readers=True)  # type: ignore[misc]
def documentation(_: str, path: str = "index.html") -> "Response":
    """Serve the documentation.

    Returns:
        The Response.
    """
    if path.endswith("/"):
        path += "index.html"
    return send_from_directory(static_folder, path)
