#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source ../../common/config/config.sh

TIMESTAMP=$(date +"%Y-%m-%d")
LOGS_DIR="/apps/octopus/logs/uploader"
mkdir -p "${LOGS_DIR}"

# Clear logs older than 30 days
find "${LOGS_DIR}" -type f -mtime +30 -print0 | xargs -0 rm -f

python uploader.py 2>&1 | tee -a "${LOGS_DIR}/${TIMESTAMP}.log"
