#!/usr/bin/env bash
ROOT_DIR="/var/lib/squirro/inputstream"
FAILED_DIR="${ROOT_DIR}/failed"

if [ ! -d "${FAILED_DIR}" ]; then
	echo "No failed directory found, exiting"
	exit 0
fi

# Look for the current folder
today=$(date +%Y-%m-%d)
cur_dir=$(
	find "${ROOT_DIR}" -maxdepth 1 -type d -name "${today}-*" -printf "%T@ %p\n" |
		sort -n |
		tail -n 1 |
		cut -d" " -f2-
)

# Ignore if there is no current folder
if [ -z "${cur_dir}" ]; then
	echo "No current folder found"
	exit 0
fi

systemctl stop sqdatasourced sqingesterd sqplumberd

# Move the failed items to the current folder
CMD="del(.retries,.wait_until,.item_history,.dequeue_retries,.dequeue_errors)|.batch_history=[]"
find "${FAILED_DIR}" -mindepth 1 -maxdepth 1 -type f | while IFS= read -r filepath; do
	file=$(basename -- "$filepath")
	echo "Retrying ${file}"
	jq -c "${CMD}" "${FAILED_DIR}/${file}" >"${cur_dir}/${file}"
	chown sqingest:squirro "${cur_dir}/${file}"
	rm "${FAILED_DIR}/${file}"
done

systemctl restart sqpdfconversiond tika
systemctl start sqdatasourced sqingesterd sqplumberd

echo "Done"
