#!/usr/bin/env bash
ROOT_DIR="/var/lib/squirro/inputstream"

# Look for the current folder
today=$(date +%Y-%m-%d)
cur_dir=$(
	find "${ROOT_DIR}" -maxdepth 1 -type d -name "${today}-*" -printf "%T@ %p\n" |
		sort -n |
		tail -n 1 |
		cut -d" " -f2-
)

# Ignore if there is no current folder
if [ -z "${cur_dir}" ]; then
	echo "No current folder found"
	exit 0
fi

systemctl stop sqdatasourced sqingesterd sqplumberd

# Move all files from dangling folders to the current folder
find "${ROOT_DIR}" -maxdepth 1 -type d \
	-not -path "${ROOT_DIR}" \
	-not -path "${cur_dir}" \
	-not -name "failed" \
	-not -name "priority" \
	-not -name "processed" |
	while read -r subdir; do
		if [ -z "$(ls -A "${subdir}")" ]; then
			echo "Removing empty directory ${subdir}"
			rmdir "${subdir}"
			continue
		fi
		echo "Migrating files from ${subdir} to ${cur_dir}"
		mv "${subdir}"/* "${cur_dir}/" 2>/dev/null
		rmdir "${subdir}"
	done

systemctl restart sqpdfconversiond tika
systemctl start sqdatasourced sqingesterd sqplumberd

echo "Done"
