#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source ../../common/config/config.sh

total_size=300000 # Total size in MB
batch_size=500    # Size of each batch in MB
sleep_time=600    # Sleep time in seconds (10 minutes)

while [ $total_size -gt 0 ]; do
	# Calculate the size for this batch
	current_batch=$((total_size < batch_size ? total_size : batch_size))

	echo "Generating $current_batch MB of fake PDFs..."
	python generate_fake_pdf.py --total-size $current_batch "$@"

	total_size=$((total_size - current_batch))

	if [ $total_size -gt 0 ]; then
		echo "Sleeping for 10 minutes..."
		sleep $sleep_time
	fi
done

echo "Finished generating all fake PDFs."
