#!/usr/bin/env bash
cd "$(dirname "$0")"
set -e
source ../../common/config/config.sh
source /etc/profile.d/squirro-python.sh

TIMESTAMP=$(date +"%Y-%m-%d")
PROJECT_ROOT=/opt/squirro/octopus

LOGS_DIR="/apps/octopus/logs/wfi_metadata_update"
mkdir -p "${LOGS_DIR}"

# Clear logs older than 30 days
find "${LOGS_DIR}" -type f -mtime +30 -print0 | xargs -0 rm -f

python $PROJECT_ROOT/scheduled_jobs/wfi_metadata_update/wfi_metadata_update.py \
	>>"${LOGS_DIR}/${TIMESTAMP}".log
