"""Update WFI metadata."""

import json
import logging

from octopus.clients import init_redis_client, init_wfi_client
from octopus.utils import set_log_verbosity

WFI_PAYLOAD_HASH = "item_id_wfi_payload_hash"
SAMPLE_SIZE = 20

set_log_verbosity(logging.INFO)


def main() -> None:
    """Entrypoint."""
    redis_client = init_redis_client()
    wfi_client = init_wfi_client()

    keys = redis_client.hkeys(WFI_PAYLOAD_HASH)

    for key in keys[:SAMPLE_SIZE]:
        if not (value := redis_client.hget(WFI_PAYLOAD_HASH, key)):
            logging.warning("Value for key %s is None.", key)
            continue

        metadata = json.loads(value)
        wfi_client.update_metadata(key.decode(), metadata)
        redis_client.hdel(WFI_PAYLOAD_HASH, key)


if __name__ == "__main__":
    main()
