#!/usr/bin/env bash
cd "$(dirname "$0")"
set -e
source ../../common/config/config.sh

BACKUP_DIR=/flash/redis-snapshots

python redis_snapshot.py \
	--backup-dir ${BACKUP_DIR} \
	--mode create >>/var/log/redis/snapshot.log 2>&1

# Remove older files
n_items=$(find "$BACKUP_DIR" -mindepth 1 -type d | wc -l)
if [ "$n_items" -gt 3 ]; then
	echo "Removing older files..."
	find "$BACKUP_DIR" -mindepth 1 -type d -printf "%T@ %p\n" |
		sort -rn |
		tail -n +4 |
		cut -d' ' -f2- |
		xargs rm -rf --
fi
