#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source ../../common/config/config.sh

TODAY=$(date +"%Y-%m-%d")
OUTPUT_DIR=/flash/octopus/Reports/"${TODAY}"
LOGS_DIR="/apps/octopus/logs/generate_batch_reports"

mkdir -p "${OUTPUT_DIR}" "${LOGS_DIR}"

# Clear logs older than 30 days
find "${LOGS_DIR}" -type f -mtime +30 -print0 | xargs -0 rm -f

python generate_batch_reports.py --output-dir "${OUTPUT_DIR}" 2>&1 |
	tee -a "${LOGS_DIR}"/"${TODAY}".log
