"""Register elasticsearch snapshot repository."""

import logging

from octopus.clients import init_es_client
from octopus.utils import set_log_verbosity

set_log_verbosity(logging.INFO)


def main() -> None:
    """Create or restore elasticsearch snapshot."""
    es = init_es_client()

    response = es.snapshot.create_repository(
        repository="es-snapshot-repo",
        body={
            "type": "fs",
            "settings": {"location": "/flash/es-snapshot-repo", "compress": True},
        },
    )
    logging.info(response)


if __name__ == "__main__":
    main()
