import json

import compute_accuracy
import pytest


def test_compute_accuracy(mock_squirro_client, mock_redis_client, items):
    mock_squirro_client.scan.return_value = items

    compute_accuracy.main()

    # Ensure client.scan was called with the correct arguments at least once
    mock_squirro_client.scan.assert_called_with(
        "project_id",
        query='-source_type:"WFI*" document_type_true:* -is_deleted:true',
        fields=["id", "keywords"],
        count=10000,
    )
    mock_redis_client.set.assert_called_with(
        "ml_accuracy_project_id",
        json.dumps(
            {
                "ALL": {"accuracy": 71, "correct": 5, "total": 7},
                "label1": {"accuracy": 100, "correct": 2, "total": 2},
                "label2": {"accuracy": 66, "correct": 2, "total": 3},
                "label3": {"accuracy": 0, "correct": 0, "total": 1},
                "label4": {"accuracy": 100, "correct": 1, "total": 1},
            }
        ),
    )


@pytest.fixture
def items():
    return [
        {
            "id": "3",
            "keywords": {
                "document_type_true": ["label2"],
                "document_type_pred": ["label2"],
            },
        },
        {
            "id": "4",
            "keywords": {
                "document_type_true": ["label2"],
                "document_type_pred": ["label1"],
            },
        },
        {
            "id": "5",
            "keywords": {
                "document_type_true": ["label3"],
                "document_type_pred": ["label1"],
            },
        },
        {
            "id": "1",
            "keywords": {
                "document_type_true": ["label1"],
                "document_type_pred": ["label1"],
            },
        },
        {
            "id": "2",
            "keywords": {
                "document_type_true": ["label1"],
                "document_type_pred": ["label1"],
            },
        },
        {
            "id": "6",
            "keywords": {
                "document_type_true": ["label2"],
                "document_type_pred": ["label2"],
            },
        },
        {
            "id": "7",
            "keywords": {
                "document_type_true": ["label4"],
                "document_type_pred": ["label4"],
            },
        },
    ]
