#!/usr/bin/env bash
cd "$(dirname "$0")"
set -e
source ../../common/config/config.sh

TIMESTAMP=$(date +"%Y-%m-%d")
YESTERDAY=$(date -d "yesterday" +"%Y%m%d")

LOGS_DIR="/apps/octopus/logs/authorisation"
mkdir -p "${LOGS_DIR}"

# Clear logs older than 30 days
find "${LOGS_DIR}" -type f -mtime +30 -print0 | xargs -0 rm -f

fpc="/flash/octopus/GCBCRM/CustomerSegmentWR_${YESTERDAY}.csv"
fpt="/flash/octopus/GCBCRM/Territorylist_${YESTERDAY}.csv"
if [ -f "$fpc" ] && [ -f "$fpt" ]; then
	python sync_company_changes.py --company-data-file "$fpc" \
		--territory-list-file "$fpt" 2>&1 |
		tee -a "${LOGS_DIR}/${TIMESTAMP}.log"
fi
