# import json
# from unittest.mock import MagicMock, patch

# import pytest
# import track_jobs
# from freezegun import freeze_time
# from requests import Response


# @patch("track_jobs.redis")
# @patch("track_jobs.SquirroClient")
# @patch("track_jobs.create_config_parser")
# class TestTrackJobs:
#     def test_update_item_metadata(self, mock_config, mock_squirro_client, mock_redis):
#         item_map = {
#             "34h4UDt7TZXOVz_XI0LbYA": {"title": "Document 2"},
#             "inQ_cNdluob3cT6mkKjmCw": {"title": "No title"},
#             "fuJOTtEkNXN3-9Xjh-s0iw": {"title": "No attachments here mate"},
#         }
#         items = [
#             {
#                 "id": "34h4UDt7TZXOVz_XI0LbYA",
#                 "source_type": "Email",
#                 "created_at": "2023-06-01 12:00:00",
#             },
#             {
#                 "id": "inQ_cNdluob3cT6mkKjmCw",
#                 "source_type": "User Upload",
#                 "created_at": "2023-06-02 12:00:00",
#             },
#             {
#                 "id": "jxVGS7LIakcYzWwRMN2e9g",
#                 "source_type": "User Upload",
#                 "created_at": "2023-06-04 12:00:00",
#             },
#         ]
#         result = [
#             {
#                 "title": "Document 2",
#                 "id": "34h4UDt7TZXOVz_XI0LbYA",
#                 "source_type": "Email",
#                 "created_at": "2023-06-01 12:00:00",
#             },
#             {
#                 "title": "No title",
#                 "id": "inQ_cNdluob3cT6mkKjmCw",
#                 "source_type": "User Upload",
#                 "created_at": "2023-06-02 12:00:00",
#             },
#             {"title": "No attachments here mate"},
#         ]

#         assert track_jobs.TrackJobs()._update_item_metadata(item_map, items) == result

#     def test_decode_hash_records(
#         self, mock_config, mock_squirro_client, mock_redis, rejection_records
#     ):
#         result = {
#             key.decode(): value.decode() for key, value in rejection_records.items()
#         }

#         assert track_jobs.TrackJobs()._decode_hash_records(rejection_records) == result

#     def test_delete_hash_records(
#         self, mock_config, mock_squirro_client, mock_redis, old_items
#     ):
#         hash_name = "test_hash"
#         old_item_ids = [item["id"] for item in old_items]

#         test_class = track_jobs.TrackJobs()
#         test_class._delete_hash_records(hash_name, old_items)

#         test_class.redis_client.hdel.assert_called_once_with(hash_name, *old_item_ids)

#     @freeze_time("2023-06-08 12:00:00")
#     def test_get_items(
#         self, mock_config, mock_squirro_client, mock_redis, new_items, old_items
#     ):
#         items = {
#             b"34h4UDt7TZXOVz_XI0LbYA": b'{"source_type": "Email", "title": "Document 2", "created_at": "2023-06-01 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#             b"inQ_cNdluob3cT6mkKjmCw": b'{"source_type": "User Upload", "title": "No title", "created_at": "2023-06-02 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#             b"fuJOTtEkNXN3-9Xjh-s0iw": b'{"source_type": "Email", "title": "No attachments here mate", "created_at": "2023-06-03 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#             b"jxVGS7LIakcYzWwRMN2e9g": b'{"source_type": "User Upload", "title": "TEST SUBJECT", "created_at": "2023-06-04 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#             b"CRfabucxfwOCXMI-lHBvSg": b'{"source_type": "Email", "title": "Document 2", "created_at": "2023-06-05 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#             b"nz8BptKI3ftx_0sNO5YUTQ": b'{"source_type": "User Upload", "title": "No title", "created_at": "2023-06-06 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#             b"uWOjLOUls-00Ifp_1KHM9A": b'{"source_type": "Email", "title": "TEST SUBJECT", "created_at": "2023-06-07 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#             b"IyQTQeM3qEdSjGOlrbqA7Q": b'{"source_type": "User Upload", "title": "No attachments here mate", "created_at": "2023-06-08 12:00:00", "user_name": "Sammy Banky", "user_email": "sb@squirro.com"}',
#         }

#         test_class = track_jobs.TrackJobs()
#         test_class.redis_client.hgetall.return_value = items

#         assert test_class._get_items() == old_items + new_items

#     def test_get_rejected_items(
#         self, mock_config, mock_squirro_client, mock_redis, rejection_records, new_items
#     ):
#         not_rejected_items = [
#             {
#                 "source_type": "Email",
#                 "title": "TEST SUBJECT",
#                 "created_at": "2023-06-07 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "uWOjLOUls-00Ifp_1KHM9A",
#             },
#         ]
#         rejected_items = [
#             {
#                 "source_type": "User Upload",
#                 "title": "No title",
#                 "created_at": "2023-06-06 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "nz8BptKI3ftx_0sNO5YUTQ",
#                 "rejection_reason": "File exceeds maximum size",
#             },
#             {
#                 "source_type": "User Upload",
#                 "title": "No attachments here mate",
#                 "created_at": "2023-06-08 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "IyQTQeM3qEdSjGOlrbqA7Q",
#                 "rejection_reason": "Item has no files",
#             },
#         ]

#         test_class = track_jobs.TrackJobs()
#         test_class.redis_client.hgetall.side_effect = [
#             rejection_records,
#             {b"nz8BptKI3ftx_0sNO5YUTQ": b"20001", b"IyQTQeM3qEdSjGOlrbqA7Q": b"20003"},
#         ]

#         assert test_class._get_rejected_items(new_items) == (
#             not_rejected_items,
#             rejected_items,
#         )

#     def test_get_duplicated_items(
#         self, mock_config, mock_squirro_client, mock_redis, new_items
#     ):
#         not_duplicated_items = [
#             {
#                 "source_type": "User Upload",
#                 "title": "No title",
#                 "created_at": "2023-06-06 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "nz8BptKI3ftx_0sNO5YUTQ",
#             },
#             {
#                 "source_type": "User Upload",
#                 "title": "No attachments here mate",
#                 "created_at": "2023-06-08 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "IyQTQeM3qEdSjGOlrbqA7Q",
#             },
#         ]
#         duplicated_items = [
#             {
#                 "source_type": "Email",
#                 "title": "TEST SUBJECT",
#                 "created_at": "2023-06-07 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "uWOjLOUls-00Ifp_1KHM9A",
#                 "rejection_reason": "The document you uploaded is a duplicate and has been rejected. This is the link to the original document: storage://localfile/fd/c0/6911cf7dfc6af9dc/test_document.pdf",
#             },
#         ]

#         test_class = track_jobs.TrackJobs()
#         test_class.redis_client.hgetall.return_value = {
#             b"uWOjLOUls-00Ifp_1KHM9A": b"The document you uploaded is a duplicate and has been rejected. This is the link to the original document: storage://localfile/fd/c0/6911cf7dfc6af9dc/test_document.pdf"
#         }

#         assert test_class._get_duplicated_items(new_items) == (
#             not_duplicated_items,
#             duplicated_items,
#         )

#     def test_get_pending_item_ids(self, mock_config, mock_squirro_client, mock_redis):
#         item_ids = [
#             b"nz8BptKI3ftx_0sNO5YUTQ",
#             b"uWOjLOUls-00Ifp_1KHM9A",
#             b"IyQTQeM3qEdSjGOlrbqA7Q",
#         ]
#         result = {item_id.decode() for item_id in item_ids}

#         test_class = track_jobs.TrackJobs()
#         test_class.redis_client.zrange.return_value = item_ids

#         assert test_class._get_pending_item_ids() == result

#     @freeze_time("2023-06-08 12:00:00")
#     def test_add_pending_items(
#         self, mock_config, mock_squirro_client, mock_redis, new_items
#     ):
#         test_class = track_jobs.TrackJobs()
#         test_class._add_pending_items(new_items)

#         test_class.redis_client.zadd.assert_called_once_with(
#             track_jobs.REDIS_PENDING_ITEM_SET,
#             {
#                 "nz8BptKI3ftx_0sNO5YUTQ": 1686052800.0,
#                 "uWOjLOUls-00Ifp_1KHM9A": 1686139200.0,
#                 "IyQTQeM3qEdSjGOlrbqA7Q": 1686225600.0,
#             },
#         )

#     def test_get_squirro_wfi_items(
#         self, mock_config, mock_squirro_client, mock_redis, new_items
#     ):
#         test_project_id = "test_project_id"
#         items_to_remove = [
#             {
#                 "source_type": "User Upload",
#                 "title": "No title",
#                 "created_at": "2023-06-06 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "nz8BptKI3ftx_0sNO5YUTQ",
#             }
#         ]
#         successful_items = [
#             {
#                 "source_type": "User Upload",
#                 "title": "No title",
#                 "created_at": "2023-06-06 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "nz8BptKI3ftx_0sNO5YUTQ",
#                 "keywords": {"wfi_status": ["Success"]},
#             }
#         ]
#         pending_items = [
#             {
#                 "source_type": "Email",
#                 "title": "TEST SUBJECT",
#                 "created_at": "2023-06-07 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "uWOjLOUls-00Ifp_1KHM9A",
#             },
#             {
#                 "source_type": "User Upload",
#                 "title": "No attachments here mate",
#                 "created_at": "2023-06-08 12:00:00",
#                 "user_name": "Sammy Banky",
#                 "user_email": "sb@squirro.com",
#                 "id": "IyQTQeM3qEdSjGOlrbqA7Q",
#             },
#         ]

#         test_class = track_jobs.TrackJobs()
#         test_class.squirro_project_id = test_project_id
#         test_class.sq_client.query.return_value = {
#             "items": [
#                 {
#                     "id": "nz8BptKI3ftx_0sNO5YUTQ",
#                     "keywords": {"wfi_status": ["Success"]},
#                 }
#             ]
#         }

#         assert test_class._get_squirro_wfi_items(new_items) == (
#             items_to_remove,
#             successful_items,
#             pending_items,
#         )

#     @pytest.mark.parametrize(
#         "status", [track_jobs.SUCCESS, track_jobs.PENDING, track_jobs.FAILURE]
#     )
#     def test_build_activity_data(
#         self, mock_config, mock_squirro_client, mock_redis, new_item, status
#     ):
#         test_project_id = "test_project_id"
#         keywords = new_item["keywords"]
#         result = {
#             "action": "document.load",
#             "source_type": new_item["source_type"],
#             "item": {
#                 "id": new_item["id"],
#                 "link": None,
#                 "title": new_item["title"],
#                 "keywords": {},
#             },
#             "user_name": new_item["user_name"],
#             "user_email": new_item["user_email"],
#             "created_at": new_item["created_at"],
#             "ingestion_status": status.capitalize(),
#             "rejection_reason": "",
#             # TODO: Remove the list size condition for company names
#             "company_name": ";".join(keywords["company_name_true"][:10]),
#             "document_type": keywords["document_type_pred"][0],
#             "document_date": keywords["document_date_true"][0],
#             "wfi_status": keywords["wfi_status"][0],
#             "project": {
#                 "id": test_project_id,
#                 "title": "EcOffice",
#             },
#         }

#         test_class = track_jobs.TrackJobs()
#         test_class.squirro_project_id = test_project_id

#         assert test_class._build_activity_data(new_item, status) == result

#     @patch("track_jobs.requests")
#     def test_send_to_activity(
#         self, mock_requests, mock_config, mock_squirro_client, mock_redis, new_item
#     ):
#         test_squirro_cluster = "test_squirro_cluster"
#         test_squirro_token = "test_squirro_token"
#         response = Response()
#         response.status_code = 200
#         mock_requests.post.return_value = response

#         test_class = track_jobs.TrackJobs()
#         test_class.squirro_cluster = test_squirro_cluster
#         test_class.squirro_token = test_squirro_token
#         test_class._send_to_activity(new_item)

#         mock_requests.post.assert_called_once_with(
#             f"{test_squirro_cluster}/activity?token={test_squirro_token}",
#             data=json.dumps(new_item),
#             headers={"Content-Type": "application/json"},
#         )

#     def test_send_email_notifications(
#         self,
#         mock_config,
#         mock_squirro_client,
#         mock_redis,
#         new_items,
#         old_items,
#     ):
#         test_emailsender_smtp_username = "test_emailsender_smtp_username"
#         data_map = {
#             track_jobs.SUCCESS: new_items,
#             track_jobs.PENDING: [],
#             track_jobs.FAILURE: old_items,
#         }

#         test_class = track_jobs.TrackJobs()
#         test_class.emailsender_smtp_username = test_emailsender_smtp_username
#         test_class.email_sender = MagicMock()
#         test_class._send_email_notifications(data_map)

#         data_map["name"] = "Sammy Banky"
#         test_class.email_sender.send_emails.assert_called_once_with(
#             subject="Octopus ingestion update",
#             recipient="sb@squirro.com",
#             template=track_jobs.EMAIL_TEMPLATE_FILE_PATH,
#             sender=test_emailsender_smtp_username,
#             data={"email": "sb@squirro.com", "data": data_map},
#         )
