#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source ../../common/config/config.sh

PROJECT_ROOT=/opt/squirro/octopus
TIMESTAMP=$(date +"%Y-%m-%d")

LOGS_DIR="/apps/octopus/logs/activity_tracking"
mkdir -p "${LOGS_DIR}"

# Clear logs older than 30 days
find "${LOGS_DIR}" -type f -mtime +30 -print0 | xargs -0 rm -f

echo "Running job tracker CRON job"
python "${PROJECT_ROOT}"/scheduled_jobs/activity_tracking/track_jobs.py 2>&1 |
	tee -a "${LOGS_DIR}/${TIMESTAMP}".log
