import pytest


@pytest.fixture
def rejection_records():
    return {
        b"20001": b"File exceeds maximum size",
        b"20002": b"File is password protected",
        b"20003": b"Item has no files",
        b"20004": b"MIME type is not supported",
        b"20005": b"Sender's email is not whitelisted",
    }


@pytest.fixture
def new_item():
    return {
        "source_type": "User Upload",
        "title": "No title",
        "created_at": "2023-06-06 12:00:00",
        "user_name": "Sammy Banky",
        "user_email": "sb@squirro.com",
        "id": "nz8BptKI3ftx_0sNO5YUTQ",
        "keywords": {
            "company_name_true": ["Apple", "Meta", "Google"],
            "document_type_pred": ["ANNUAL REVIEW"],
            "document_date_true": ["07/07/2023"],
            "wfi_status": ["Success"],
        },
    }


@pytest.fixture
def new_items():
    return [
        {
            "source_type": "User Upload",
            "title": "No title",
            "created_at": "2023-06-06 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "nz8BptKI3ftx_0sNO5YUTQ",
        },
        {
            "source_type": "Email",
            "title": "TEST SUBJECT",
            "created_at": "2023-06-07 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "uWOjLOUls-00Ifp_1KHM9A",
        },
        {
            "source_type": "User Upload",
            "title": "No attachments here mate",
            "created_at": "2023-06-08 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "IyQTQeM3qEdSjGOlrbqA7Q",
        },
    ]


@pytest.fixture
def old_items():
    return [
        {
            "source_type": "Email",
            "title": "Document 2",
            "created_at": "2023-06-01 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "34h4UDt7TZXOVz_XI0LbYA",
        },
        {
            "source_type": "User Upload",
            "title": "No title",
            "created_at": "2023-06-02 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "inQ_cNdluob3cT6mkKjmCw",
        },
        {
            "source_type": "Email",
            "title": "No attachments here mate",
            "created_at": "2023-06-03 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "fuJOTtEkNXN3-9Xjh-s0iw",
        },
        {
            "source_type": "User Upload",
            "title": "TEST SUBJECT",
            "created_at": "2023-06-04 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "jxVGS7LIakcYzWwRMN2e9g",
        },
        {
            "source_type": "Email",
            "title": "Document 2",
            "created_at": "2023-06-05 12:00:00",
            "user_name": "Sammy Banky",
            "user_email": "sb@squirro.com",
            "id": "CRfabucxfwOCXMI-lHBvSg",
        },
    ]
