#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source ../common/config/config.sh

for folder in *; do
	for subfolder in "${folder}"/*; do
		# Check if subfolder is a directory
		if [[ -d "${subfolder}" ]]; then
			# Check if subfolder contains a upload.sh script
			if [[ -f "${subfolder}/upload.sh" ]]; then
				echo "Uploading ${subfolder}..."
				bash "${subfolder}/upload.sh"
			fi
		fi
	done
done
