import pytest


@pytest.fixture
def mock_user_metadata_raw() -> "dict[bytes,bytes]":
    return {
        b"myecm1@ocbc.com": b'{"role": "RM", "role_ocbc": "Workbench:RM", "rmcode": "myecm1", "org_unit_id": "RE078", "org_unit_type": "Team", "job_title": "WCM(WCM 80) RM", "ecm_role": "user"}',
        b"myecm2@ocbc.com": b'{"role": "RM", "role_ocbc": "Workbench:RM", "rmcode": "myecm2", "org_unit_id": "RE078", "org_unit_type": "Team", "job_title": "WCM(WCM 80) RM", "ecm_role": "user"}',
    }


@pytest.fixture
def mock_creating_user_data() -> bytes:
    return b'{\n    "myecm3@ocbc.com":{\n        "role": "RM",\n        "role_ocbc": "Workbench:RM",\n        "rmcode": "myecm2",\n        "org_unit_id": "RE078",\n        "org_unit_type": "Team",\n        "job_title": "WCM(WCM 80) RM",\n        "ecm_role": "user"\n    }\n}'


@pytest.fixture
def mock_deleting_data() -> "dict[str, str]":
    return {
        "ecm_role": "admin",
        "job_title": "WCM(WCM 80) RM",
        "org_unit_id": "RE078",
        "org_unit_type": "Team",
        "rmcode": "myecm3",
        "role": "RM",
        "role_ocbc": "Workbench:RM",
    }


@pytest.fixture
def mock_single_user_data_redis() -> bytes:
    return b'{"role": "RM", "role_ocbc": "Workbench:RM", "rmcode": "myecm3", "org_unit_id": "RE078", "org_unit_type": "Team", "job_title": "WCM(WCM 80) RM", "ecm_role": "admin"}'


@pytest.fixture
def mock_user_metadata_processed() -> "dict":
    return {
        "myecm1@ocbc.com": {
            "ecm_role": "user",
            "job_title": "WCM(WCM 80) RM",
            "org_unit_id": "RE078",
            "org_unit_type": "Team",
            "rmcode": "myecm1",
            "role": "RM",
            "role_ocbc": "Workbench:RM",
        },
        "myecm2@ocbc.com": {
            "ecm_role": "user",
            "job_title": "WCM(WCM 80) RM",
            "org_unit_id": "RE078",
            "org_unit_type": "Team",
            "rmcode": "myecm2",
            "role": "RM",
            "role_ocbc": "Workbench:RM",
        },
    }
