# User roles API
[[TOC]]

## Overview

This API enables the RMWB team to add/remove/edit user roles and metadata for EcOffice users.

This user metadata consists of multiple fields useful for the user to login and get the right entitlements, and view the correct type of documents.

This endpoint consists of a single route which can handle 4 HTTP methods, with each method handling different functionality.

URL - `<SERVER URL>/studio/user_roles_repo/user_roles`

The 4 methods are -

1. `GET` - To fetch all users' information
2. `POST` - To add user'(s) role information
3. `DELETE` - To delete user'(s) role information from the DB
4. `PATCH` - To modify user'(s) role information
## Methods

### `GET`
#### Description
This method enables viewing all users currently stored in Squirro's Redis DB to enable users to use EcOffice. Hitting this method returns all users currently stored in Redis by the RMWB team, which pushes it via the `/POST` route.

#### URL
`<SERVER URL>/studio/user_roles_repo/user_roles` <br>
#### Method
`GET`

#### Requirements
N/A

#### Sample output
```
{
    "myecm1@ocbc.com":{
        "role": "RM",
        "lan_id":"A001",
        "role_ocbc": "Workbench:RM",
        "rmcode": "myecm1",
        "org_unit_id": "RE078",
        "org_unit_type": "Team",
        "job_title": "WCM(WCM 80) RM",
        "ecm_role": "user",
    },
    "myecm2@ocbc.com":{
        "role": "RM",
        "lan_id":"A002",
        "role_ocbc": "Workbench:RM",
        "rmcode": "myecm2",
        "org_unit_id": "RE078",
        "org_unit_type": "Team",
        "job_title": "WCM(WCM 80) RM",
        "ecm_role": "user",
    }
}
```
### `POST`
#### Description
This method enables user creation, which will then be stored in Squirro's Redis DB.

#### URL
`<SERVER URL>/studio/user_roles_repo/user_roles` <br>

#### Method
`POST`

#### Requirements
- Content-Type = application/json
- ECM role (ecm_role) values that are accepted are
    - `admin`
    - `user`
    <br>
    These values are case insensitive.

#### Sample input
```
{
    "myecm1@ocbc.com":{
        "role": "RM",
        "role_ocbc": "Workbench:RM",
        "lan_id":"A001",
        "rmcode": "myecm1",
        "org_unit_id": "RE078",
        "org_unit_type": "Team",
        "job_title": "WCM(WCM 80) RM",
        "ecm_role": "user",
    }
}
```
This endpoint accepts JSON formatted data in the request body.
#### Sample output
In case of success -
```
Done
```
In case of invalid Content-Type -

```
Invalid request data format passed - only application/json is accepted
```

In case the user has already been added to the DB via the API before -
```
email address already exists - <email address> already exists in the DB. Use PATCH method to modify user information"
```
#### Error codes
##### `400 - bad request`
This can happen on 2 occasions -
1. email address already exists in the DB - only new users (new email addresses to user roles) can be added via the POST method
2. Invalid user ECM role

Note that in case of a single error within a request, none of the multiple users will be added

### `DELETE`
#### Description
This method deletes user metadata of the specified users as per their email addresses. Note that multiple users can be deleted via this endpoint, and email addresses are to always be passed as an array in the request body.
#### URL
`<SERVER URL>/studio/user_roles_repo/user_roles` <br>
#### Method
`DELETE`
#### Requirements
- Content-Type = application/json
#### Sample input
```
{
    "users":["myecm1@ocbc.com", "myecm2@ocbc.com"]
}
```
This endpoint accepts JSON formatted data in the request body, with the key "users" containing the list of email addresses of users as strings.

#### Sample output
In case of success -
```
Done
```
In case of invalid Content-Type -

```
Invalid request data format passed - only application/json is accepted
```
In case of email addresss that don't exist yet in the DB -
```
Invalid email address <email address> - email address doesn't exist in the DB yet
```
#### Error codes
##### `400 - bad request`
This happens when the email address does not exists in the DB. Only users with existing email addresses can be removed.
Note that in case of a single error within a request, none of the multiple users will be deleted

##### `415 - unsupported media type`
This happens when the content-type as found in the headers is not 'application/json'

#### Method
`PATCH`

#### Requirements
- Content-Type = application/json
- ECM role (ecm_role) values that are accepted are
    - `admin`
    - `user`
    - `user`
    <br>
    These values are case insensitive.

#### Sample input
```
{
    "myecm1@ocbc.com":{
        "role": "RM",
        "role_ocbc": "Workbench:RM",
        "rmcode": "myecm1",
        "lan_id":"A001",
        "org_unit_id": "RE078",
        "org_unit_type": "Team",
        "job_title": "WCM(WCM 80) RM",
        "ecm_role": "user",
    }
}
```

OR
```
{
    "myecm1@ocbc.com":{
        "role": "RM",
        "lan_id":"A001",
        "role_ocbc": "Workbench:RM",
        "rmcode": "myecm1",
    }
}
```

This endpoint accepts JSON formatted data in the request body. Additionally, only fields that are being being modified can be passed in, instead of writing the entire user object.

#### Sample output
In case of success -
```
Done
```
In case of invalid Content-Type -

```
Invalid request data format passed - only application/json is accepted
```

In case of a user that hasn't been added yet -
```
email address does not exist - <email address>. Add user information via the POST method
```
#### Error codes
##### `400 - bad request`
This can happen on 2 occasions -
1. email address doesn't exist in the DB - only existing users (existing email addresses to user information) can be modified via the PATCH method
2. Invalid user ECM role
Note that in case of a single error within a request, none of the multiple users will be modified

##### `415 - unsupported media type`
This happens when the content-type as found in the headers is not 'application/json'
