return StudioPlugins.Base.extend({
  index: Pages.StudioBase.extend({
    FULL_WIDTH: true,
    form: [
      {
        view: Properties.MultilineText,
        config: {
          inputName: "statusPermissions",
          infoText: "Status Permissions",
        },
      },
      {
        view: Properties.StudioButton,
        config: {
          inputName: "saveConfig",
          text: "Save",
        },
      },
    ],
    events: {
      'click input[name="saveConfig"]': "_saveConfig",
    },

    render: function () {
      const rendered = Pages.StudioBase.prototype.render.apply(this, arguments);
      this.overlayLoader();
      this.$('[name="statusPermissions"]').height(300).css({
        overflow: "scroll",
      });

      $.ajax({
        url: `/studio/status_permissions/get_config`,
        dataType: "json",
        cache: false,
        success: _.bind(function (data) {
          this.hideOverlayedLoader();
          this._updateView(data);
        }, this),
        error: _.bind(function (e) {
          this.hideOverlayedLoader();
          if (e.status == 404) {
            Materialize.toast(
              "Status permissions has not been configured",
              3000,
            );
            this._updateView({
              statusPermissions: {},
            });
          } else {
            Materialize.toast(
              "Failed to fetch: " + e.responseJSON.message,
              5000,
            );
          }
        }, this),
      });

      return rendered;
    },
    _updateView: (data) => {
      this.$('[name="statusPermissions"]').val(
        JSON.stringify(data.status_permissions, null, 4),
      );
    },
    _saveConfig: (e) => {
      _.halt(e);
      const form = this.$("form").serializeObject();

      let req = {};
      try {
        req = {
          status_permissions: JSON.parse(form.statusPermissions),
        };
      } catch (error) {
        Materialize.toast("Failed to read config: " + error, 10000);
        return;
      }

      $.ajax({
        method: "POST",
        url: `/studio/status_permissions/set_config`,
        data: JSON.stringify(req),
        contentType: "application/json",
        success: _.bind(function (response) {
          Materialize.toast("Config successfully saved.", 3000, "rounded");
          // this not bound to view instance
          this.$('[name="statusPermissions"]').val(
            JSON.stringify(data.status_permissions, null, 4),
          );
        }, this),
        error: _.bind(function (e) {
          Materialize.toast("Update failed: " + e.responseJSON.message, 10000);
        }, this),
      });
    },
  }),
});
