import pytest

from .plugin import Helper

get_format_test_cases: "list[tuple]" = [
    # INTEGER
    ("1", (1, "integer_format")),
    ("+1", (1, "integer_format")),
    ("-1", (-1, "integer_format")),
    ("1000", (1000, "integer_format")),
    ("+1000", (1000, "integer_format")),
    ("-1000", (-1000, "integer_format")),
    ("1,000", (1000, "integer_format")),
    ("-1,000", (-1000, "integer_format")),
    ("1,000,000", (1_000_000, "integer_format")),
    ("-1,000,000", (-1_000_000, "integer_format")),
    # FLOAT
    ("1.0", (1.0, "float_format")),
    ("0.1", (0.1, "float_format")),
    ("+1.0", (1.0, "float_format")),
    ("+ 1.0", (1.0, "float_format")),
    ("-1.0", (-1.0, "float_format")),
    ("1000.0", (1000.0, "float_format")),
    ("-1000.0", (-1000.0, "float_format")),
    ("1,000.0", (1000.0, "float_format")),
    ("-1,000.0", (-1000.0, "float_format")),
    # PERCENTAGE
    ("1%", (0.01, "percentage_format")),
    ("1.2%", (0.012, "percentage_format")),
    ("100%", (1, "percentage_format")),
    ("1000%", (10, "percentage_format")),
    ("1,000%", (10, "percentage_format")),
    ("-1%", (-0.01, "percentage_format")),
    # CURRENCY
    ("$0.50", (0.5, "currency_format")),
    ("$1", (1, "currency_format")),
    ("$100.0", (100.0, "currency_format")),
    ("$1000", (1000, "currency_format")),
    ("$1,000", (1000, "currency_format")),
    ("$1,000,000", (1000000, "currency_format")),
    ("$1,000.0", (1000.0, "currency_format")),
    # OTHERS
    ("test", ("test", None)),
    ("", ("", None)),
    (None, ("", None)),
]


class TestHelper:
    def test_strip_chars(self) -> None:
        assert Helper.strip_chars("$1,000") == "1000"
        assert Helper.strip_chars("10%") == "10"
        assert Helper.strip_chars("1 000.0") == "1000.0"

    @pytest.mark.parametrize("test_input,expected_output", get_format_test_cases)
    def test_get_format(self, test_input: "str", expected_output: "tuple") -> None:
        assert Helper.get_format(test_input) == expected_output
