return StudioPlugins.Base.extend({
    collection: BaseCollection.extend({
        type: 'StudioExtauthSaml',

        constructor: function () {
            return this._getFromCache.apply(this, []);
        },

        url: function () {
            return '/studio/extauth_saml/configs';
        },
    }),

    index: Pages.StudioListBase.extend({
        columns: [{ key: 'domain', label: 'Domain' }],

        action: 'save',
    }),

    form: Pages.StudioBase.extend({
        form: [
            {
                view: Properties.StaticHtml,
                config: {
                    html:
                        'Set up Single Sign-On with SAML. This needs a configuration change on the server to become active. Read the instruction on <a href="http://go.squirro.com/setup-saml">setting up SAML SSO for Squirro</a> online for how to enable this.',
                },
            },
            {
                view: Properties.Text,
                config: {
                    inputName: 'domain',
                    infoText: 'Domain on which this is active (* for any domain)',
                },
            },
            {
                view: Properties.Bool,
                config: {
                    inputName: 'enabled',
                    infoText: 'Enabled',
                },
            },
            {
                view: Properties.Text,
                config: {
                    inputName: 'entity_id',
                    infoText: 'Entity ID (Default url is https://sso.squirro.com/o/saml2/entity)',
                },
            },
            {
                view: Properties.StaticHtml,
                config: {
                    html: '<br>Metadata file<style>form .button-row { margin-top: 0 }</style>',
                },
            },
            {
                view: Properties.StudioFileUpload,
                config: {
                    inputName: 'metadata',
                    text: 'Metadata file',
                },
            },
            {
                view: Properties.StaticHtml,
                config: {
                    html: '<br>Certificate file',
                },
            },
            {
                view: Properties.StudioFileUpload,
                config: {
                    inputName: 'certificate',
                    text: 'Certificate file',
                },
            },
            {
                view: Properties.StudioDropdown,
                config: {
                    inputName: 'group_id',
                    infoText: 'User group (set for all users)',
                    action: 'groups',
                },
            },
            {
                view: Properties.Text,
                config: {
                    inputName: 'groups_field',
                    infoText: 'Group names field (provided by SAML provider)',
                },
            },
            {
                view: Properties.Text,
                config: {
                    inputName: 'groups_roles',
                    infoText: 'Mapping of groups to Squirro roles',
                },
            },
            {
                view: Properties.MultilineText,
                config: {
                    inputName: 'user_data',
                    infoText: 'Fields to map in as user values',
                },
            },
            {
                view: Properties.MultilineText,
                config: {
                    inputName: 'session_data',
                    infoText: "Fields to map in the user's session, useful for query templates.",
                },
            },
            {
                view: Properties.StudioButton,
                config: {
                    inputName: 'save',
                    text: 'Save Settings',
                    action: 'save',
                },
            },
        ],
    }),
});
