# ruff: noqa
# import json
# from typing import TYPE_CHECKING
# from unittest.mock import patch

# import pytest

# if TYPE_CHECKING:
#     from typing import Dict

# from email_whitelisting.plugin import plugin

# plugin.testing = True
# plugin_test_client = plugin.test_client()


# @patch("email_whitelisting.plugin.get_injected")
# class TestEmailWhitelisting:
#     def test_add_email_fail(self, mock_get_injected, project_config: "Dict") -> None:
#         mock_client = mock_get_injected()
#         mock_client.get_project_configuration.return_value = project_config

#         fail_cases: "Dict[str, None | Dict]" = {
#             "Missing parameters in the request": None,
#             "Missing email": {"project_id": "project-id"},
#             "Missing project id": {"email_address": "test@email.com"},
#             "Invalid email address": {
#                 "project_id": "project-id",
#                 "email_address": "testemail.com",
#             },
#         }

#         for test, request_body in fail_cases.items():
#             if request_body is None:
#                 response = plugin_test_client.post("/add_email")
#             else:
#                 response = plugin_test_client.post(
#                     "/add_email",
#                     data=json.dumps(request_body),
#                     content_type="application/json",
#                 )
#             assert response.status_code == 400
#             assert test in response.text

#     def test_add_email_success(self, mock_get_injected, project_config: "Dict") -> None:
#         mock_client = mock_get_injected()
#         mock_client.get_project_configuration.return_value = project_config

#         data: "Dict[str, str]" = {
#             "project_id": "project-id",
#             "email_address": "test1@email.com",
#         }

#         response = plugin_test_client.post(
#             "/add_email",
#             data=json.dumps(data),
#             content_type="application/json",
#         )

#         assert response.status_code == 201
#         mock_client.set_project_configuration.assert_called_once_with(
#             project_id="project-id",
#             key="app.whitelisted-emails",
#             value={"email_addresses": ["test@email.com", "test1@email.com"]},
#         )

#     def test_delete_email(self, mock_get_injected, project_config: "Dict") -> None:
#         mock_client = mock_get_injected()
#         mock_client.get_project_configuration.return_value = project_config

#         response = plugin_test_client.delete("/project-id/test@email.com")

#         assert response.status_code == 204
#         mock_client.set_project_configuration.assert_called_once_with(
#             project_id="project-id",
#             key="app.whitelisted-emails",
#             value={"email_addresses": []},
#         )


# @pytest.fixture
# def project_config() -> "Dict":
#     return {
#         "config": {
#             "app.whitelisted-emails": {
#                 "value": {
#                     "email_addresses": ["test@email.com"],
#                 },
#             },
#         }
#     }
