// This file is an excerpt of the config.js of
// the OOTB project_configuration studio plugin

return StudioPlugins.Base.extend({
  collection: BaseCollection.extend({
    type: "StudioConfigProject",

    initialize: function (models, options) {
      this.project_id = options.project_id;
    },

    _ignoreCache() {
      return true;
    },

    url: function () {
      return `/studio/email_whitelisting/${this.project_id}`;
    },

    comparator: function (model) {
      return model.id;
    },

    parse: function (res) {
      return _.map(res, function (item) {
        return { email_address: item, id: item };
      });
    },
  }),

  index: Pages.StudioListBase.extend({
    events: _.extend(Pages.StudioListBase.prototype.events, {
      "submit .js-config-search-form": "onSearch",
      "keyup .js-config-search": "onSearch",
    }),

    columns: [{ key: "email_address", label: "Email Address" }],
    editLabel: null,
    reallyDeleteLabel: "Are you sure you want to remove this email address?",
    action: "new",

    onDelete(ev) {
      ev.preventDefault();

      const id = $(ev.currentTarget).data("id");
      const collection = this.collection;
      const model = collection.get(id);

      // eslint-disable-next-line
      if (window.confirm(this.reallyDeleteLabel)) {
        model.destroy({
          wait: true,
          success: function (model, response) {
            if (response && response.key) {
              // This was a reset action. Re-add the response as
              // a new model.
              response.id = response.key;
              collection.add([response]);
            }
          },
        });
      }
    },

    onSearch: function (ev) {
      ev.preventDefault();

      const query = this.$(".js-config-search").val();
      if (_.isEmpty(query)) {
        // Unhide everything
        this.$(".js-table .hide-by-search").removeClass("hide-by-search");
      } else {
        this.applySearch(query);
      }
    },

    /**
     * Execute the search.
     *
     * This should really be done with Backbone sub-views, etc. but this
     * was much easier in the context of a studio plugin.
     */
    applySearch: function (query) {
      // Convert the query into a regular expression. We do this in a way
      // that the order matters, but between various elements other
      // characters can appear.
      // For example the queries 'ap', 'app.test', 'a.t' will all match
      // on 'app.test-string'.
      const REGEXP_SPECIAL_CHARS = ".*+?^${}()[]";
      const regPattern = query.replace(/./g, function (match) {
        var token = match;
        if (REGEXP_SPECIAL_CHARS.indexOf(match) > -1) {
          token = "\\" + match;
        }
        if (match === " ") {
          // Spaces are only used as word boundary
          token = ".*";
        } else if (match === ".") {
          // Allow anything before and after the dot
          token = ".*" + token + ".*";
        }
        return token;
      });
      const reg = new RegExp(regPattern, "i");

      const $table = this.$(".js-table");
      this.collection.forEach(function (model) {
        const values = _.values(model.pick("email_address"));
        const valueMatch = _.any(values, function (value) {
          return reg.test("" + value);
        });
        $table
          .find('[data-id="' + model.attributes.email_address + '"]')
          .toggleClass("hide-by-search", !valueMatch);
      });
    },

    template: _.template(`
  <style>
  .config-search-container {
      margin: 0 24px;
  }
  .hide-by-search {
      display: none;
  }

  .squirro-body table.config-ui tbody tr {
      line-height: 22px;
      height: auto;
  }
  .squirro-body table.config-ui tbody td {
      vertical-align: top;
      padding: 5px !important;
  }
  .squirro-body table.config-ui tbody td:first-child {
      padding-left: 24px !important;
  }

  table.config-ui .edit-form {
      display: flex;
  }
  table.config-ui form > *:not(.row) {
      margin-right: 3px !important;
  }
  table.config-ui form .value {
      flex-grow: 1;
  }
  table.config-ui .input-field {
      margin: 0;
  }
  table.config-ui form .row {
      margin: 0;
  }
  </style>
  <% if (showAdd) { %>
      <a
          href="#studio/<%- project_id %>/<%- plugin.name %>/add"
          class="btn-floating btn-large waves-effect waves-light addButton right"
      >
          <i class="material-icons">
              add
          </i>
      </a>
  <% } %>

  <div class="col <%- fullWidth ? '' : 's6 offset-s3' %>">
      <h3><%- plugin.title %></h3>
      <% if (_.isEmpty(list)) { %>
          <div>No whitelisted email addresses.</div>
      <% } else { %>
          <div class="vSearch config-search-container">
              <form action="#" class="navbar-search js-config-search-form form" role="search">
                  <div class="search-container">
                      <input
                          type="text"
                          class="query js-config-search"
                          placeholder="Search email addresses"
                          id="studio-config-search"
                      >
                      <div class="reset-wrapper label-icon valign-wrapper" for="studio-config-search">
                          <i class="material-icons js-search-btn">search</i>
                      </div>
                  </div>
              </form>
          </div>
          <table class="js-table config-ui">
              <thead>
                  <tr>
                      <% _.each(columns, function (column) { %>
                          <th><%- column.label %></th>
                      <% }) %>
                      <th></th>
                  </tr>
              </thead>
              <tbody>
                  <% _.each(list, function (item) { %>
                      <tr class="value-row <%- item.changed ? 'changed-value' : 'original-value' %>" data-id="<%- item.email_address %>">
                          <% _.each(columns, function (column) { %>
                              <td>
                                  <% if (column.key === 'value' && item.type === 'dictionary') { %>
                                      <%- JSON.stringify(item[column.key]) %></td>
                                  <% } else { %>
                                      <%- item[column.key] %></td>
                                  <% } %>
                          <% }) %>
                          <td class="actions">
                              <% if (item.delete !== 'noop') { %>
                                  <a class="table-action js-delete" data-id="<%- item.email_address %>">
                                      <%- item.delete === 'reset' ? "Reset" : "Remove" %>
                                  </a>
                              <% } %>
                              <a href="#" class="table-action js-edit"><%- editLabel %></a>
                          </td>
                      </tr>
                  <% }) %>
              </tbody>
          </table>
      <% } %>

  </div>
  `),
  }),

  form: Pages.StudioBase.extend({
    initialize: function () {
      Pages.StudioBase.prototype.initialize.apply(this, arguments);
    },

    render: function () {
      const that = this;
      Pages.StudioBase.prototype.render.apply(this, arguments);

      // Attach custom click event to the button
      _.each(this._views, function (view) {
        if (view.inputName === "add") {
          view._onSubmitSuccess = function (data, status, xhr) {
            that.collection.add(that.model);

            // Redirect back to list view after saving
            Backbone.history.navigate(
              Backbone.history.fragment.replace(/\/add$/, ""),
              {
                trigger: true,
              }
            );
          };
        }
      });
    },
    form: [
      {
        view: Properties.Text,
        config: {
          inputName: "email_address",
          infoText: "Enter an email address",
        },
      },
      {
        view: Properties.StudioButton,
        config: {
          inputName: "add",
          text: "Add",
          action: "add_email",
        },
      },
    ],
  }),
});
