return StudioPlugins.Base.extend({
  index: Pages.StudioBase.extend({
    FULL_WIDTH: true,
    form: [
      {
        view: Properties.MultilineText,
        config: {
          inputName: "distributionList",
          infoText: "Distribution List",
        },
      },
      {
        view: Properties.MultilineText,
        config: {
          inputName: "triggers",
          infoText: "Status Triggers",
        },
      },
      {
        view: Properties.StudioButton,
        config: {
          inputName: "saveConfig",
          text: "Save",
        },
      },
    ],
    events: {
      'click input[name="saveConfig"]': "_saveConfig",
    },

    render: function () {
      const rendered = Pages.StudioBase.prototype.render.apply(this, arguments);
      this.overlayLoader();
      this.$('[name="triggers"]').height(300).css({
        overflow: "scroll",
      });
      this.$('[name="distributionList"]').height(200).css({
        overflow: "scroll",
      });

      $.ajax({
        url: `/studio/email_config/get_config`,
        dataType: "json",
        cache: false,
        success: _.bind(function (data) {
          this.hideOverlayedLoader();
          this._updateView(data);
        }, this),
        error: _.bind(function (e) {
          this.hideOverlayedLoader();
          if (e.status == 404) {
            Materialize.toast(
              "Email notifications has not been configured",
              3000,
            );
            this._updateView({
              distributionList: {},
              emailTriggers: {},
            });
          } else {
            Materialize.toast(
              "Failed to fetch: " + e.responseJSON.message,
              5000,
            );
          }
        }, this),
      });

      return rendered;
    },
    _updateView: (data) => {
      this.$('[name="distributionList"]').val(
        JSON.stringify(data.distribution_list, null, 4),
      );
      this.$('[name="triggers"]').val(JSON.stringify(data.triggers, null, 4));
    },
    _saveConfig: (e) => {
      _.halt(e);
      const form = this.$("form").serializeObject();

      let req = {};
      try {
        req = {
          distribution_list: JSON.parse(form.distributionList),
          triggers: JSON.parse(form.triggers),
        };
      } catch (error) {
        Materialize.toast("Failed to read config: " + error, 10000);
        return;
      }

      $.ajax({
        method: "POST",
        url: `/studio/email_config/set_config`,
        data: JSON.stringify(req),
        contentType: "application/json",
        success: _.bind(function (response) {
          Materialize.toast("Config successfully saved.", 3000, "rounded");
          // this not bound to view instance
          this.$('[name="distributionList"]').val(
            JSON.stringify(data.distribution_list, null, 4),
          );
          this.$('[name="triggers"]').val(
            JSON.stringify(data.email_triggers, null, 4),
          );
        }, this),
        error: _.bind(function (e) {
          Materialize.toast("Update failed: " + e.responseJSON.message, 10000);
        }, this),
      });
    },
  }),
});
